/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.Patches;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Table
extends JTable {
    private MyCellEditorRemover myEditorRemover;

    public Table() {
        this(new DefaultTableModel());
    }

    public Table(TableModel model) {
        super(model);
        this.addMouseListener(new MyMouseListener());
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnMarginChanged(ChangeEvent e) {
                if (Table.this.cellEditor != null) {
                    Table.this.cellEditor.stopCellEditing();
                }
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }
        });
        this.getTableHeader().setDefaultRenderer(new MyTableHeaderRenderer());
        boolean marker = Patches.SUN_BUG_ID_4503845;
    }

    public void removeNotify() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this.myEditorRemover);
        keyboardFocusManager.removePropertyChangeListener("focusOwner", this.myEditorRemover);
        super.removeNotify();
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.myEditorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myEditorRemover = new MyCellEditorRemover(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("focusOwner", this.myEditorRemover);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myEditorRemover);
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editorComp.requestFocusInWindow();
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public void fixColumnWidthToHeader(int columnIdx) {
        TableColumn column = this.getColumnModel().getColumn(columnIdx);
        int width = this.getTableHeader().getFontMetrics(this.getTableHeader().getFont()).stringWidth(this.getColumnName(columnIdx)) + 2;
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int row;
            int[] selectedRows;
            if (SwingUtilities.isRightMouseButton(e) && (selectedRows = Table.this.getSelectedRows()).length < 2 && (row = Table.this.rowAtPoint(e.getPoint())) != -1) {
                Table.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private final class MyCellEditorRemover
    implements PropertyChangeListener {
        private final KeyboardFocusManager myFocusManager;

        public MyCellEditorRemover(KeyboardFocusManager focusManager) {
            this.myFocusManager = focusManager;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (!Table.this.isEditing()) {
                return;
            }
            for (Component c = this.myFocusManager.getFocusOwner(); c != null; c = c.getParent()) {
                if (c == Table.this) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getWindowAncestor(Table.this)) break;
                Table.this.getCellEditor().stopCellEditing();
                break;
            }
        }
    }

    private static class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private MyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                if (!table.isEnabled()) {
                    this.setForeground(UIUtil.getTextInactiveTextColor());
                }
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIUtil.getTableHeaderCellBorder());
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

