/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class OptionsDialog
extends DialogWrapper {
    private JCheckBox myCheckBoxDoNotShowDialog;
    protected final Project myProject;

    protected String getDoNotShowMessage() {
        return CommonBundle.message("dialog.options.do.not.show", new Object[0]);
    }

    protected OptionsDialog(Project project) {
        super(project, true);
        this.myProject = project;
    }

    protected OptionsDialog(Project project, boolean canBeParent) {
        super(project, canBeParent);
        this.myProject = project;
    }

    protected OptionsDialog(boolean canBeParent) {
        super(canBeParent);
        this.myProject = null;
    }

    protected OptionsDialog(Component parent, boolean canBeParent) {
        super(parent, canBeParent);
        this.myProject = null;
    }

    protected JComponent createSouthPanel() {
        this.myCheckBoxDoNotShowDialog = new JCheckBox(this.getDoNotShowMessage());
        JComponent southPanel = super.createSouthPanel();
        if (!this.canBeHidden()) {
            return southPanel;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myCheckBoxDoNotShowDialog, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)southPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myCheckBoxDoNotShowDialog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.myCheckBoxDoNotShowDialog.setSelected(!this.isToBeShown());
        return panel;
    }

    public static boolean shiftIsPressed(int inputEventModifiers) {
        return (inputEventModifiers & 1) != 0;
    }

    protected void doOKAction() {
        if (this.canBeHidden()) {
            this.setToBeShown(this.toBeShown(), true);
        }
        super.doOKAction();
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public void doCancelAction() {
        if (this.shouldSaveOptionsOnCancel() && this.canBeHidden()) {
            this.setToBeShown(this.toBeShown(), false);
        }
        super.doCancelAction();
    }

    protected abstract boolean isToBeShown();

    protected abstract void setToBeShown(boolean var1, boolean var2);

    protected boolean canBeHidden() {
        return true;
    }

    protected abstract boolean shouldSaveOptionsOnCancel();
}

