/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingListCellRenderer
extends DefaultListCellRenderer {
    private Map<Object, String> myValueMap;

    public MappingListCellRenderer(Map<Object, String> valueMap) {
        this.myValueMap = valueMap;
    }

    public MappingListCellRenderer(Pair<Object, String> ... valuePairs) {
        this.myValueMap = new HashMap<Object, String>();
        for (Pair<Object, String> valuePair : valuePairs) {
            this.myValueMap.put(valuePair.getFirst(), valuePair.getSecond());
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String newValue = this.myValueMap.get(value);
        if (newValue != null) {
            this.setText(newValue);
        }
        return this;
    }
}

