/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.TableViewModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTableModel<Item>
extends TableViewModel<Item>
implements ItemRemovable {
    private ColumnInfo[] myColumnInfos;
    private List<Item> myItems;
    private int mySortByColumn;
    private int mySortingType = 1;
    private boolean myIsSortable = true;

    public ListTableModel(ColumnInfo ... columnInfos) {
        this(columnInfos, new ArrayList(), 0);
    }

    public ListTableModel(ColumnInfo[] columnNames, List<Item> items, int selectedColumn) {
        this.myColumnInfos = columnNames;
        this.myItems = items;
        this.mySortByColumn = selectedColumn;
        this.setSortable(true);
        this.resort();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].isCellEditable(this.myItems.get(rowIndex));
    }

    public Class getColumnClass(int columnIndex) {
        return this.myColumnInfos[columnIndex].getColumnClass();
    }

    @Override
    public ColumnInfo[] getColumnInfos() {
        return this.myColumnInfos;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnInfos[column].getName();
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnInfos.length;
    }

    @Override
    public void setItems(List<Item> items) {
        this.myItems = items;
        this.fireTableDataChanged();
        this.resort();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].valueOf(this.myItems.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.myItems.size()) {
            this.myColumnInfos[columnIndex].setValue(this.myItems.get(rowIndex), aValue);
        }
    }

    public boolean setColumnInfos(ColumnInfo[] columnInfos) {
        if (this.myColumnInfos != null && Arrays.equals(columnInfos, this.myColumnInfos)) {
            return false;
        }
        this.myColumnInfos = columnInfos;
        this.fireTableStructureChanged();
        return true;
    }

    @Override
    public List<Item> getItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    @Override
    public void sortByColumn(int columnIndex) {
        if (this.mySortByColumn == columnIndex) {
            this.reverseOrder(columnIndex);
        } else {
            this.mySortByColumn = columnIndex;
            this.mySortingType = 1;
            this.resort();
        }
    }

    @Override
    public void sortByColumn(int columnIndex, int sortingType) {
        if (this.mySortByColumn != columnIndex) {
            this.mySortByColumn = columnIndex;
            this.mySortingType = sortingType;
            this.resort();
        } else if (this.mySortingType != sortingType) {
            this.reverseOrder(columnIndex);
        }
    }

    private void reverseOrder(int columnIndex) {
        this.mySortingType = this.mySortingType == 1 ? 2 : 1;
        if (this.myIsSortable && this.myColumnInfos[columnIndex].isSortable()) {
            Collections.reverse(this.myItems);
            this.fireTableDataChanged();
        }
    }

    protected Object getAspectOf(int aspectIndex, Object item) {
        return this.myColumnInfos[aspectIndex].valueOf(item);
    }

    private void resort() {
        ColumnInfo columnInfo;
        if (this.myIsSortable && this.mySortByColumn >= 0 && this.mySortByColumn < this.myColumnInfos.length && (columnInfo = this.myColumnInfos[this.mySortByColumn]).isSortable()) {
            columnInfo.sort(this.myItems);
            if (this.mySortingType == 2) {
                Collections.reverse(this.myItems);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getSortedColumnIndex() {
        return this.mySortByColumn;
    }

    @Override
    public int getSortingType() {
        return this.mySortingType;
    }

    @Override
    public void setSortable(boolean aBoolean) {
        this.myIsSortable = aBoolean;
    }

    @Override
    public boolean isSortable() {
        return this.myIsSortable;
    }

    public int indexOf(Item item) {
        return this.myItems.indexOf(item);
    }

    @Override
    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public Object getItem(int rowIndex) {
        return this.getItems().get(rowIndex);
    }
}

