/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import javax.swing.AbstractSpinnerModel;

class IntegerSpinnerModel
extends AbstractSpinnerModel {
    private final int myMinValue;
    private final int myMaxValue;
    private int myValue = 0;

    public IntegerSpinnerModel(int myMinValue, int myMaxValue) {
        this.myMinValue = myMinValue;
        this.myMaxValue = myMaxValue;
    }

    public Object getNextValue() {
        int result;
        if (this.myMaxValue >= 0 && this.myValue == this.myMaxValue) {
            if (this.myMinValue < 0) {
                return null;
            }
            result = this.myMinValue;
        } else {
            result = this.myValue + 1;
        }
        return new Integer(result);
    }

    public Object getPreviousValue() {
        int result;
        if (this.myMinValue >= 0 && this.myValue == this.myMinValue) {
            if (this.myMaxValue < 0) {
                return null;
            }
            result = this.myMaxValue;
        } else {
            result = this.myValue - 1;
        }
        return new Integer(result);
    }

    public Object getValue() {
        return String.valueOf(this.myValue);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setStringValue((String)value);
        }
        if (value instanceof Integer) {
            this.setIntegerValue((Integer)value);
        }
        this.fireStateChanged();
    }

    private void setIntegerValue(Integer integer) {
        this.myValue = integer;
    }

    private void setStringValue(String s) {
        this.myValue = Integer.parseInt(s);
    }

    public int getIntValue() {
        return this.myValue;
    }
}

