/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;

public class FileLabel
extends JLabel {
    protected File myFile;
    private boolean myShowIcon = true;
    private static final int PREFFERED_TEXT_LENGTH = 50;
    private FilePathSplittingPolicy myPolicy = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR;

    public FileLabel() {
    }

    public void setShowIcon(boolean showIcon) {
        this.myShowIcon = showIcon;
    }

    public FileLabel(File file) {
        this.myFile = file;
    }

    public static String getFilePath(File file) {
        return file.getPath();
    }

    public void setFile(File ioFile) {
        this.myFile = ioFile;
        if (this.myShowIcon) {
            this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon());
        } else {
            this.setIcon(null);
        }
    }

    public String getText() {
        if (this.myFile == null) {
            return "";
        }
        int width = this.getWidth();
        if (this.getIcon() != null) {
            width -= this.getIconWidth();
        }
        return this.myPolicy.getOptimalTextForComponent(this.myFile, this, width);
    }

    public void pack() {
        int packedWidth = this.getIconWidth() + this.getPrefferregWidth();
        this.setPreferredSize(new Dimension(packedWidth, this.getPreferredSize().height));
    }

    private int getPrefferregWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.myPolicy.getPresentableName(this.myFile, 50));
    }

    public int getIconWidth() {
        Icon icon = this.getIcon();
        if (icon == null) {
            return 0;
        }
        return icon.getIconWidth() + this.getIconTextGap();
    }
}

