/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Line;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorAdapter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.EditorAdapter");
    private final Editor myEditor;
    private Alarm myFlushAlarm = new Alarm();
    private final Collection<Line> myLines = new ArrayList<Line>();
    private final Project myProject;
    private final Runnable myFlushDeferredRunnable = new Runnable(){

        public void run() {
            EditorAdapter.this.flushStoredLines();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushStoredLines() {
        ArrayList<Line> lines;
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            lines = new ArrayList<Line>(this.myLines);
            this.myLines.clear();
        }
        ApplicationManager.getApplication().runWriteAction(this.writingCommand(lines));
    }

    public EditorAdapter(Editor editor, Project project) {
        this.myEditor = editor;
        this.myProject = project;
        LOG.assertTrue(this.myEditor.isViewer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(String string, TextAttributes attrs) {
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            this.myLines.add(new Line(string, attrs));
        }
        if (this.myFlushAlarm.getActiveRequestCount() == 0) {
            this.myFlushAlarm.addRequest(this.myFlushDeferredRunnable, 200, ModalityState.NON_MODAL);
        }
    }

    private Runnable writingCommand(final Collection<Line> lines) {
        final Runnable command = new Runnable(){

            public void run() {
                int endBefore;
                Document document = EditorAdapter.this.myEditor.getDocument();
                StringBuffer buffer = new StringBuffer();
                for (Line line : lines) {
                    buffer.append(line.getValue());
                }
                int endBeforeLine = endBefore = document.getTextLength();
                document.insertString(endBefore, buffer.toString());
                for (Line line : lines) {
                    EditorAdapter.this.myEditor.getMarkupModel().addRangeHighlighter(endBeforeLine, endBeforeLine + line.getValue().length(), 3000, line.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
                    endBeforeLine += line.getValue().length();
                }
                EditorAdapter.this.shiftCursorToTheEndOfDocument();
            }
        };
        return new Runnable(){

            public void run() {
                CommandProcessor.getInstance().executeCommand(EditorAdapter.this.myProject, command, "", null);
            }
        };
    }

    private void shiftCursorToTheEndOfDocument() {
        this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
        this.myEditor.getSelectionModel().removeSelection();
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }
}

