/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.util.ui.OptionsMessageDialog;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfirmationDialog
extends OptionsMessageDialog {
    private final VcsShowConfirmationOption myOption;

    public static boolean requestForConfirmation(@NotNull VcsShowConfirmationOption option, @NotNull Project project, @NotNull String message, @NotNull String title, @Nullable Icon icon) {
        if (option == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/ConfirmationDialog.requestForConfirmation must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/ConfirmationDialog.requestForConfirmation must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ui/ConfirmationDialog.requestForConfirmation must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/ui/ConfirmationDialog.requestForConfirmation must not be null");
        }
        if (option.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return false;
        }
        ConfirmationDialog dialog = new ConfirmationDialog(project, message, title, icon, option);
        dialog.show();
        return dialog.isOK();
    }

    public ConfirmationDialog(Project project, String message, String title, Icon icon, VcsShowConfirmationOption option) {
        super(project, message, title, icon);
        this.myOption = option;
        this.init();
    }

    protected String getOkActionName() {
        return CommonBundle.message("button.yes", new Object[0]);
    }

    protected String getCancelActionName() {
        return CommonBundle.message("button.no", new Object[0]);
    }

    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        VcsShowConfirmationOption.Value optionValue = value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        this.myOption.setValue(optionValue);
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }
}

