/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnInfo<Item, Aspect> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.ColumnInfo");
    private String myName;
    public static ColumnInfo[] EMPTY_ARRAY = new ColumnInfo[0];

    public ColumnInfo(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public abstract Aspect valueOf(Item var1);

    public final boolean isSortable() {
        return this.getComparator() != null;
    }

    @Nullable
    public Comparator<Item> getComparator() {
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public void sort(List<Item> list) {
        LOG.assertTrue(list != null);
        Comparator<Item> comparator = this.getComparator();
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    public Class getColumnClass() {
        return String.class;
    }

    public boolean isCellEditable(Item item) {
        return false;
    }

    public void setValue(Item item, Aspect value) {
    }

    @Nullable
    public TableCellRenderer getRenderer(Item item) {
        return null;
    }

    public TableCellRenderer getCustomizedRenderer(Item o, TableCellRenderer renderer) {
        return renderer;
    }

    @Nullable
    public TableCellEditor getEditor(Item o) {
        return null;
    }

    @Nullable
    public String getMaxStringValue() {
        return null;
    }

    @Nullable
    public String getPreferredStringValue() {
        return null;
    }

    public int getAdditionalWidth() {
        return 0;
    }

    public int getWidth(JTable table) {
        return -1;
    }

    public void setName(String s) {
        this.myName = s;
    }

    @Nullable
    public String getTooltipText() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public boolean hasError() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringColumn
    extends ColumnInfo<String, String> {
        public StringColumn(String name) {
            super(name);
        }

        @Override
        public String valueOf(String item) {
            return item;
        }
    }
}

