/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class BaseButtonBehavior {
    private JComponent myComponent;
    private boolean myHovered;
    private boolean myPressedByMouse;
    private boolean mySelected;

    public BaseButtonBehavior(JComponent component) {
        this.myComponent = component;
        this.myComponent.addMouseListener(new MyMouseListener());
    }

    public boolean isHovered() {
        return this.myHovered;
    }

    public void setHovered(boolean hovered) {
        this.myHovered = hovered;
        this.myComponent.repaint();
    }

    public boolean isPressedByMouse() {
        return this.myPressedByMouse;
    }

    public void setPressedByMouse(boolean pressedByMouse) {
        this.myPressedByMouse = pressedByMouse;
        this.myComponent.repaint();
    }

    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    public boolean isPressed() {
        return this.isSelected() || this.isPressedByMouse();
    }

    protected abstract void execute(MouseEvent var1);

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            BaseButtonBehavior.this.setHovered(true);
            BaseButtonBehavior.this.myComponent.repaint();
        }

        public void mouseExited(MouseEvent e) {
            BaseButtonBehavior.this.setHovered(false);
            BaseButtonBehavior.this.myComponent.repaint();
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            BaseButtonBehavior.this.setPressedByMouse(true);
            BaseButtonBehavior.this.myComponent.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            BaseButtonBehavior.this.setPressedByMouse(false);
            Point point = e.getPoint();
            if (point.x < 0 || point.x > BaseButtonBehavior.this.myComponent.getWidth()) {
                return;
            }
            if (point.y < 0 || point.y > BaseButtonBehavior.this.myComponent.getHeight()) {
                return;
            }
            BaseButtonBehavior.this.execute(e);
        }
    }
}

