/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.Timer;
import javax.swing.SwingUtilities;

public abstract class Animator
implements Disposable {
    private String myName;
    private int myTotalFrames;
    private int myCycleLength;
    private Timer myTimer;
    private int myCurrentFrame = 0;
    private int myQueuedFrames = 0;
    private boolean myRepeatable;
    private int myRepeatCount;
    private boolean myLastAnimated;

    public Animator(String name, int totalFrames, int cycleLength, boolean repeatable, final int interCycleGap, final int maxRepeatCount) {
        this.myName = name;
        this.myTotalFrames = totalFrames;
        this.myCycleLength = cycleLength;
        this.myRepeatable = repeatable;
        this.myTimer = new Timer(this.myName, this.myCycleLength / this.myTotalFrames){

            protected void onTimer() throws InterruptedException {
                boolean repaint = true;
                if (!Animator.this.isAnimated()) {
                    if (Animator.this.myLastAnimated) {
                        Animator.this.myCurrentFrame = 0;
                        Animator.this.myQueuedFrames = 0;
                        Animator.this.myLastAnimated = false;
                    } else {
                        repaint = false;
                    }
                } else {
                    Animator.this.myLastAnimated = true;
                    if (Animator.this.myQueuedFrames > Animator.this.myTotalFrames) {
                        return;
                    }
                    if (Animator.this.myCurrentFrame + 1 < Animator.this.myTotalFrames) {
                        Animator.this.myCurrentFrame++;
                    } else if (Animator.this.myRepeatable) {
                        if (maxRepeatCount == -1 || Animator.this.myRepeatCount < maxRepeatCount) {
                            Animator.this.myRepeatCount++;
                            Animator.this.myCurrentFrame = 0;
                            if (interCycleGap > 0) {
                                Thread.sleep(interCycleGap - this.getSpan());
                            }
                        } else {
                            repaint = false;
                            this.suspend();
                            Animator.this.myRepeatCount = 0;
                            Animator.this.onAnimationMaxCycleReached();
                        }
                    } else {
                        repaint = false;
                        this.suspend();
                    }
                }
                if (repaint) {
                    Animator.this.myQueuedFrames++;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Animator.this.myQueuedFrames--;
                            Animator.this.paintNow(Animator.this.myCurrentFrame);
                        }
                    });
                }
            }
        };
    }

    protected void onAnimationMaxCycleReached() throws InterruptedException {
    }

    public void suspend() {
        this.myTimer.suspend();
    }

    public void resume() {
        this.myTimer.resume();
    }

    public void setTakInitialDelay(boolean take) {
        this.myTimer.setTakeInitialDelay(take);
    }

    public abstract void paintNow(int var1);

    public void dispose() {
        this.myTimer.dispose();
    }

    public boolean isRunning() {
        return this.myTimer.isRunning() && this.myLastAnimated;
    }

    public boolean isAnimated() {
        return true;
    }

    public void reset() {
        this.myCurrentFrame = 0;
        this.myRepeatCount = 0;
    }

    public boolean isDisposed() {
        return this.myTimer.isDisposed();
    }
}

