/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AnimatedIcon
extends JComponent
implements Disposable {
    private Icon[] myIcons;
    private Dimension myPrefSize = new Dimension();
    private int myCurrentIconIndex;
    private Icon myPassiveIcon;
    private boolean myRunning = true;
    protected Animator myAnimator;
    private String myName;

    protected AnimatedIcon(String name) {
        this.myName = name;
    }

    protected final void init(Icon[] icons, Icon passiveIcon, int cycleLength, int interCycleGap, int maxRepeatCount) {
        this.myIcons = icons;
        this.myPassiveIcon = passiveIcon;
        this.myPrefSize = new Dimension();
        for (Icon each : icons) {
            this.myPrefSize.width = Math.max(each.getIconWidth(), this.myPrefSize.width);
            this.myPrefSize.height = Math.max(each.getIconHeight(), this.myPrefSize.height);
        }
        this.myPrefSize.width = Math.max(passiveIcon.getIconWidth(), this.myPrefSize.width);
        this.myPrefSize.height = Math.max(passiveIcon.getIconHeight(), this.myPrefSize.height);
        UIUtil.removeQuaquaVisualMarginsIn(this);
        this.myAnimator = new Animator(this.myName, icons.length, cycleLength, true, interCycleGap, maxRepeatCount){

            public void paintNow(int frame) {
                AnimatedIcon.this.myCurrentIconIndex = frame;
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }

            protected void onAnimationMaxCycleReached() throws InterruptedException {
                AnimatedIcon.this.onAnimationMaxCycleReached();
            }

            public boolean isAnimated() {
                return AnimatedIcon.this.isAnimated();
            }
        };
    }

    protected void onAnimationMaxCycleReached() throws InterruptedException {
    }

    public void resume() {
        this.myRunning = true;
        this.myAnimator.resume();
    }

    public void addNotify() {
        super.addNotify();
        if (this.myRunning) {
            this.myAnimator.resume();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.myAnimator.suspend();
    }

    public void suspend() {
        this.myRunning = false;
        this.myAnimator.suspend();
        this.repaint();
    }

    public void dispose() {
        this.myAnimator.dispose();
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.myPrefSize.width + insets.left + insets.right, this.myPrefSize.height + insets.top + insets.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics g) {
        g.setColor(UIUtil.getBgFillColor(this));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Icon icon = this.myAnimator.isRunning() ? this.myIcons[this.myCurrentIconIndex] : this.getPassiveIcon();
        Dimension size = this.getSize();
        int x = (size.width - icon.getIconWidth()) / 2;
        int y = (size.height - icon.getIconHeight()) / 2;
        icon.paintIcon(this, g, x, y);
    }

    protected Icon getPassiveIcon() {
        return this.myPassiveIcon;
    }

    public boolean isAnimated() {
        return true;
    }
}

