/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames = new HashSet<String>();

    public UniqueNameGenerator(Collection elements, @Nullable Function<Object, String> namer) {
        for (Object t : elements) {
            this.myExistingNames.add(namer != null ? namer.fun(t) : t.toString());
        }
    }

    public UniqueNameGenerator() {
    }

    @Override
    public final boolean value(String candidate) {
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(String name, String prefix, String suffix) {
        return this.value(prefix + name + suffix);
    }

    public static String generateUniqueName(String defaultName, String prefix, String suffix, final Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, new Condition<String>(){

            @Override
            public boolean value(String s) {
                return !existingNames.contains(s);
            }
        });
    }

    public static String generateUniqueName(String defaultName, String prefix, String suffix, Condition<String> validator) {
        String defaultFullName = prefix + defaultName + suffix;
        if (validator.value(defaultFullName)) {
            return defaultFullName;
        }
        int i = 2;
        String fullName;
        while (!validator.value(fullName = prefix + defaultName + i + suffix)) {
            ++i;
        }
        return fullName;
    }

    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, this);
        this.myExistingNames.add(result);
        return result;
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

