/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.Arrays;

public class StringSearcher {
    private String myPattern = null;
    private char[] myPatternArray = null;
    private int myPatternLength;
    private int[] mySearchTable = new int[128];
    private boolean myCaseSensitive = true;
    private boolean myForwardDirection = true;
    private boolean myJavaIdentifier;

    public StringSearcher() {
    }

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public StringSearcher(String pattern) {
        this.setPattern(pattern);
    }

    public String getPattern() {
        return this.myPattern;
    }

    public void setPattern(String pattern) {
        this.myPattern = pattern;
        this.myPatternArray = this.myCaseSensitive ? this.myPattern.toCharArray() : this.myPattern.toLowerCase().toCharArray();
        this.myPatternLength = this.myPatternArray.length;
        Arrays.fill(this.mySearchTable, -1);
        this.myJavaIdentifier = true;
        if (pattern.length() > 0) {
            this.myJavaIdentifier = Character.isJavaIdentifierPart(pattern.charAt(0)) && Character.isJavaIdentifierPart(pattern.charAt(pattern.length() - 1));
        }
    }

    public void setCaseSensitive(boolean value) {
        this.myCaseSensitive = value;
        this.myPatternArray = this.myCaseSensitive ? this.myPattern.toCharArray() : this.myPattern.toLowerCase().toCharArray();
        Arrays.fill(this.mySearchTable, -1);
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isJavaIdentifier() {
        return this.myJavaIdentifier;
    }

    public void setForwardDirection(boolean value) {
        this.myForwardDirection = value;
        Arrays.fill(this.mySearchTable, -1);
    }

    public boolean isForwardDirection() {
        return this.myForwardDirection;
    }

    public int scan(CharSequence text) {
        return this.scan(text, 0, text.length());
    }

    public int scan(CharSequence text, int _start, int _end) {
        int step;
        if (this.myForwardDirection) {
            int step2;
            int end = _end - this.myPatternLength;
            for (int start = _start; start <= end; start += step2) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = text.charAt(start + i);
                if (!this.myCaseSensitive) {
                    lastChar = StringUtil.toLowerCase(lastChar);
                }
                if (this.myPatternArray[i] == lastChar) {
                    --i;
                    while (i >= 0) {
                        char c = text.charAt(start + i);
                        if (!this.myCaseSensitive) {
                            c = StringUtil.toLowerCase(c);
                        }
                        if (this.myPatternArray[i] != c) break;
                        --i;
                    }
                    if (i < 0) {
                        return start;
                    }
                }
                if ((step2 = '\u0000' <= lastChar && lastChar < '\u0080' ? this.mySearchTable[lastChar & 0x7F] : 1) > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar & 0x7F] = step2 = this.myPatternLength - index - 1;
            }
            return -1;
        }
        int end = text.length() - this.myPatternLength + 1;
        for (int start = 1; start <= end; start += step) {
            int index;
            int i = this.myPatternLength - 1;
            char lastChar = text.charAt(text.length() - (start + i));
            if (!this.myCaseSensitive) {
                lastChar = StringUtil.toLowerCase(lastChar);
            }
            if (this.myPatternArray[this.myPatternLength - 1 - i] == lastChar) {
                --i;
                while (i >= 0) {
                    char c = text.charAt(text.length() - (start + i));
                    if (!this.myCaseSensitive) {
                        c = StringUtil.toLowerCase(c);
                    }
                    if (this.myPatternArray[this.myPatternLength - 1 - i] != c) break;
                    --i;
                }
                if (i < 0) {
                    return text.length() - start - this.myPatternLength + 1;
                }
            }
            if ((step = '\u0000' <= lastChar && lastChar < '\u0080' ? this.mySearchTable[lastChar & 0x7F] : 1) > 0) continue;
            for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[this.myPatternLength - 1 - index] != lastChar; --index) {
            }
            this.mySearchTable[lastChar & 0x7F] = step = this.myPatternLength - index - 1;
        }
        return -1;
    }

    public int scan(char[] text, int startOffset, int endOffset) {
        int res = this.scan(new CharArrayCharSequence(text), startOffset, endOffset);
        return res >= 0 ? res : -1;
    }
}

