/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

public class MergingCharSequence
implements CharSequence {
    private CharSequence s1;
    private CharSequence s2;

    public MergingCharSequence(CharSequence s1, CharSequence s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    public int length() {
        return this.s1.length() + this.s2.length();
    }

    public char charAt(int index) {
        if (index < this.s1.length()) {
            return this.s1.charAt(index);
        }
        return this.s2.charAt(index - this.s1.length());
    }

    public CharSequence subSequence(int start, int end) {
        if (start < this.s1.length() && end < this.s1.length()) {
            return this.s1.subSequence(start, end);
        }
        if (start >= this.s1.length() && end >= this.s1.length()) {
            return this.s2.subSequence(start - this.s1.length(), end - this.s1.length());
        }
        return new MergingCharSequence(this.s1.subSequence(start, this.s1.length()), this.s2.subSequence(0, end - this.s1.length()));
    }

    public String toString() {
        return ((Object)this.s1).toString() + ((Object)this.s2).toString();
    }
}

