/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.CommonBundle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateFormatUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long[] DELIMS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
    private static final Period[] PERIOD = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};

    private DateFormatUtil() {
    }

    public static String formatDuration(long delta) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < DELIMS.length; ++i) {
            long delim = DELIMS[i];
            int n = (int)(delta / delim);
            if (n == 0) continue;
            buf.append(DateFormatUtil.composeDurationMessage(PERIOD[i], n));
            buf.append(' ');
            delta %= delim;
        }
        if (buf.length() == 0) {
            return CommonBundle.message("date.format.less.than.a.minute", new Object[0]);
        }
        return buf.toString().trim();
    }

    private static String composeDurationMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.n.years", n);
    }

    public static String formatBetweenDates(long d1, long d2) {
        int i;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            return CommonBundle.message("date.format.right.now", new Object[0]);
        }
        int n = -1;
        for (i = 0; i < DELIMS.length; ++i) {
            long delim = DELIMS[i];
            if (delta < delim) continue;
            n = (int)(delta / delim);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                return CommonBundle.message("date.format.a.few.moments.ago", new Object[0]);
            }
            return DateFormatUtil.someTimeAgoMessage(PERIOD[i], n);
        }
        if (d2 < d1) {
            if (n <= 0) {
                return CommonBundle.message("date.format.in.a.few.moments", new Object[0]);
            }
            return DateFormatUtil.composeInSomeTimeMessage(PERIOD[i], n);
        }
        return "";
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.in.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.in.n.years", n);
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return CommonBundle.message("date.format.n.years.ago", n);
    }

    public static String formatDate(Date today, Date date, Locale locale) {
        boolean isYesterday;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        int todayYear = calendar.get(1);
        int todayDayOfYear = calendar.get(6);
        calendar.setTime(date);
        int year = calendar.get(1);
        int dayOfYear = calendar.get(6);
        DateFormat defaultDateFormat = SimpleDateFormat.getDateTimeInstance(3, 3, locale);
        DateFormat timeDefaultFormat = DateFormat.getTimeInstance(3, locale);
        boolean isYesterdayOnPreviousYear = todayYear == year + 1 && todayDayOfYear == 1 && dayOfYear == calendar.getActualMaximum(6);
        boolean bl = isYesterday = isYesterdayOnPreviousYear || todayYear == year && todayDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            return CommonBundle.message("date.format.yesterday", new Object[0]) + " " + timeDefaultFormat.format(date);
        }
        if (year != todayYear) {
            return defaultDateFormat.format(date);
        }
        if (todayDayOfYear == dayOfYear) {
            return CommonBundle.message("date.format.today", new Object[0]) + " " + timeDefaultFormat.format(date);
        }
        return defaultDateFormat.format(date);
    }

    public static String formatDate(Date current_date, Date date) {
        return DateFormatUtil.formatDate(current_date, date, Locale.getDefault());
    }

    public static String formatFrequency(long tm) {
        return CommonBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(tm, 0L));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

