/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayUtil;

public class CharSequenceSubSequence
implements CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;

    public CharSequenceSubSequence(CharSequence chars) {
        this(chars, 0, chars.length());
    }

    public CharSequenceSubSequence(CharSequence chars, int start, int end) {
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    public final int length() {
        return this.myEnd - this.myStart;
    }

    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            return this;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    public String toString() {
        if (this.myChars instanceof String) {
            return ((String)this.myChars).substring(this.myStart, this.myEnd);
        }
        return new String(CharArrayUtil.fromSequence(this.myChars), this.myStart, this.myEnd - this.myStart);
    }
}

