/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.text.CharacterIterator;

public class CharSequenceCharacterIterator
implements CharacterIterator {
    private CharSequence myChars;
    private int myCurPosition;

    public CharSequenceCharacterIterator(CharSequence chars) {
        this.myChars = chars;
        this.myCurPosition = 0;
    }

    public char current() {
        if (this.myCurPosition < 0) {
            this.myCurPosition = 0;
            return '\uffff';
        }
        if (this.myCurPosition >= this.myChars.length()) {
            this.myCurPosition = this.myChars.length();
            return '\uffff';
        }
        return this.myChars.charAt(this.myCurPosition);
    }

    public char first() {
        this.myCurPosition = 0;
        return this.current();
    }

    public char last() {
        this.myCurPosition = this.myChars.length() - 1;
        return this.current();
    }

    public char next() {
        ++this.myCurPosition;
        return this.current();
    }

    public char previous() {
        --this.myCurPosition;
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.myChars.length();
    }

    public int getIndex() {
        return this.myCurPosition;
    }

    public char setIndex(int position) {
        if (position < 0 || position > this.myChars.length()) {
            throw new IllegalArgumentException("Wrong index: " + position);
        }
        this.myCurPosition = position;
        return this.current();
    }

    public Object clone() {
        CharSequenceCharacterIterator it = new CharSequenceCharacterIterator(this.myChars);
        it.myCurPosition = this.myCurPosition;
        return it;
    }
}

