/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.OrderedSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.VerifyingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPicoContainer
implements MutablePicoContainer,
Serializable {
    private ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private Set<PicoContainer> children;
    private Map<Object, ComponentAdapter> componentKeyToAdapterCache;
    private Collection<ComponentAdapter> componentAdapters;
    private List<ComponentAdapter> orderedComponentAdapters;

    public DefaultPicoContainer(@NotNull ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        if (componentAdapterFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/pico/DefaultPicoContainer.<init> must not be null");
        }
        this.children = new HashSet<PicoContainer>();
        this.componentKeyToAdapterCache = Collections.synchronizedMap(new HashMap());
        this.componentAdapters = Collections.synchronizedCollection(new OrderedSet());
        this.orderedComponentAdapters = Collections.synchronizedList(new OrderedSet());
        this.componentAdapterFactory = componentAdapterFactory;
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance((PicoContainer)parent);
    }

    protected DefaultPicoContainer() {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), null);
    }

    public Collection<ComponentAdapter> getComponentAdapters() {
        return Collections.unmodifiableCollection(this.componentAdapters);
    }

    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter o : this.getComponentAdapters()) {
            ComponentAdapter componentAdapter = o;
            if (!ReflectionCache.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    private void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List getComponentInstancesOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!ReflectionCache.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        for (ComponentAdapter componentAdapter : this.orderedComponentAdapters) {
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return result;
    }

    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    @Nullable
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(ComponentAdapter componentAdapter) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(ComponentAdapter componentAdapter) {
        Throwable firstLevelException = null;
        Object instance = null;
        try {
            instance = componentAdapter.getComponentInstance((PicoContainer)this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (firstLevelException != null) {
            if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                return instance;
            }
            throw firstLevelException;
        }
        this.addOrderedComponentAdapter(componentAdapter);
        return instance;
    }

    @Nullable
    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection<ComponentAdapter> adapters = this.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            Object o = this.getInstance(adapter);
            if (o == null || !o.equals(componentInstance)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentAdapterFactory, (PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }

    public boolean addChildContainer(PicoContainer child) {
        return this.children.add(child);
    }

    public boolean removeChildContainer(PicoContainer child) {
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        ArrayList<ComponentAdapter> adapters = new ArrayList<ComponentAdapter>(this.getComponentAdapters());
        for (ComponentAdapter adapter : adapters) {
            adapter.accept(visitor);
        }
        ArrayList<PicoContainer> allChildren = new ArrayList<PicoContainer>(this.children);
        for (PicoContainer child : allChildren) {
            child.accept(visitor);
        }
    }

    public ComponentAdapter registerComponentInstance(Object component) {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) {
        return this.registerComponent((ComponentAdapter)new InstanceComponentAdapter(componentKey, componentInstance));
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) {
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        return this.registerComponent(componentAdapter);
    }

    public PicoContainer getParent() {
        return this.parent;
    }
}

