/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HTTPProxySettingsDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class IOExceptionDialog
extends JDialog {
    private JPanel mainPanel;
    private JButton cancelButton;
    private JButton tryAgainButton;
    private JButton setupButton;
    private JTextArea errorTextArea;
    private JLabel errorLabel;
    private boolean cancelPressed = false;

    public IOExceptionDialog(IOException e, String title, String errorText) {
        super(JOptionPane.getRootFrame(), title, true);
        this.$$$setupUI$$$();
        new MnemonicHelper().register(this.getContentPane());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                IOExceptionDialog.this.cancelPressed = true;
                IOExceptionDialog.this.dispose();
            }
        });
        this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        e.printStackTrace(writer);
        writer.flush();
        this.errorTextArea.setText(baos.toString());
        this.errorTextArea.setCaretPosition(0);
        this.errorLabel.setText(errorText);
        this.setupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTTPProxySettingsDialog dlg = new HTTPProxySettingsDialog();
                dlg.show();
            }
        });
        this.tryAgainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IOExceptionDialog.this.cancelPressed = false;
                IOExceptionDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IOExceptionDialog.this.cancelPressed = true;
                IOExceptionDialog.this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        Dimension parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension ownSize = this.getPreferredSize();
        this.setLocation((parentSize.width - ownSize.width) / 2, (parentSize.height - ownSize.height) / 2);
        this.pack();
    }

    public static boolean showErrorDialog(IOException e, String title, String text) {
        final IOExceptionDialog dlg = new IOExceptionDialog(e, title, text);
        try {
            Runnable doRun = new Runnable(){

                public void run() {
                    dlg.setVisible(true);
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                doRun.run();
            } else {
                SwingUtilities.invokeAndWait(doRun);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        return !dlg.cancelPressed;
    }

    public static void main(String[] args) {
        IOExceptionDialog.showErrorDialog(new IOException("test"), "Test", "Something failed");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextArea jTextArea;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.setupButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/CommonBundle").getString("dialog.ioexception.proxy"));
        jPanel.add((Component)jButton3, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.tryAgainButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/CommonBundle").getString("dialog.ioexception.tryagain"));
        jPanel.add((Component)jButton2, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.cancelButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
        jPanel.add((Component)jButton, new GridConstraints(5, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.errorTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jTextArea.setEditable(false);
        jScrollPane.setViewportView(jTextArea);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CommonBundle").getString("dialog.ioexception.ioerror"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.errorLabel = jLabel = new JLabel();
        jLabel.setText("##");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

