/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.net.AuthenticationDialog;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.jdom.Element;

public class HttpConfigurable
implements JDOMExternalizable,
ApplicationComponent {
    public boolean USE_HTTP_PROXY = false;
    public String PROXY_HOST = "";
    public int PROXY_PORT = 80;
    public boolean PROXY_AUTHENTICATION = false;
    public String PROXY_LOGIN = "";
    public String PROXY_PASSWORD_CRYPT = "";
    public boolean KEEP_PROXY_PASSWORD = false;

    public static HttpConfigurable getInstance() {
        return ServiceManager.getService(HttpConfigurable.class);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = "";
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String proxyPassword = this.PROXY_PASSWORD_CRYPT;
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = "";
        }
        DefaultJDOMExternalizer.writeExternal(this, element);
        this.PROXY_PASSWORD_CRYPT = proxyPassword;
    }

    public String getComponentName() {
        return "HttpConfigurable";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getPlainProxyPassword() {
        return new String(new Base64().decode(HttpConfigurable.getInstance().PROXY_PASSWORD_CRYPT.getBytes()));
    }

    public void setPlainProxyPassword(String password) {
        this.PROXY_PASSWORD_CRYPT = new String(new Base64().encode(password.getBytes()));
    }

    private Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                if (HttpConfigurable.this.PROXY_AUTHENTICATION && !HttpConfigurable.this.KEEP_PROXY_PASSWORD) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            AuthenticationDialog dlg = new AuthenticationDialog(this.getRequestingHost(), this.getRequestingPrompt());
                            dlg.show();
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(runnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return new PasswordAuthentication(HttpConfigurable.this.PROXY_LOGIN, HttpConfigurable.this.getPlainProxyPassword().toCharArray());
            }
        };
    }

    public void prepareURL(String url) throws IOException {
        URLConnection connection;
        block3: {
            this.setAuthenticator();
            connection = new URL(url).openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.connect();
            try {
                connection.getInputStream();
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) break block3;
                throw (IOException)e;
            }
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public void setAuthenticator() {
        if (this.USE_HTTP_PROXY) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", this.PROXY_HOST);
            System.setProperty("http.proxyPort", Integer.toString(this.PROXY_PORT));
            Authenticator.setDefault(this.getAuthenticator());
        } else {
            System.setProperty("proxySet", "false");
            Authenticator.setDefault(null);
        }
    }
}

