/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class HTTPProxySettingsPanel
extends JPanel {
    private JPanel myMainPanel;
    private JTextField myProxyLoginTextField;
    private JPasswordField myProxyPasswordTextField;
    private JCheckBox myProxyAuthCheckBox;
    private JTextField myProxyPortTextField;
    private JTextField myProxyHostTextField;
    private JCheckBox myUseProxyCheckBox;
    private JCheckBox myRememberProxyPasswordCheckBox;
    private JLabel myProxyLoginLabel;
    private JLabel myProxyPasswordLabel;
    private JLabel myHostNameLabel;
    private JLabel myPortNumberLabel;

    public boolean isModified() {
        boolean isModified = false;
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        isModified |= httpConfigurable.USE_HTTP_PROXY != this.myUseProxyCheckBox.isSelected();
        isModified |= httpConfigurable.PROXY_AUTHENTICATION != this.myProxyAuthCheckBox.isSelected();
        isModified |= httpConfigurable.KEEP_PROXY_PASSWORD != this.myRememberProxyPasswordCheckBox.isSelected();
        isModified |= !Comparing.strEqual(httpConfigurable.PROXY_LOGIN, this.myProxyLoginTextField.getText());
        isModified |= !Comparing.strEqual(httpConfigurable.getPlainProxyPassword(), new String(this.myProxyPasswordTextField.getPassword()));
        try {
            isModified |= httpConfigurable.PROXY_PORT != Integer.valueOf(this.myProxyPortTextField.getText());
        }
        catch (NumberFormatException e) {
            isModified = true;
        }
        return isModified |= !Comparing.strEqual(httpConfigurable.PROXY_HOST, this.myProxyHostTextField.getText());
    }

    public HTTPProxySettingsPanel() {
        this.$$$setupUI$$$();
        this.add(this.myMainPanel);
        this.myProxyAuthCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTTPProxySettingsPanel.this.enableProxyAuthentication(HTTPProxySettingsPanel.this.myProxyAuthCheckBox.isSelected());
            }
        });
        this.myUseProxyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTTPProxySettingsPanel.this.enableProxy(HTTPProxySettingsPanel.this.myUseProxyCheckBox.isSelected());
            }
        });
        this.reset();
    }

    public void reset() {
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        this.myUseProxyCheckBox.setSelected(httpConfigurable.USE_HTTP_PROXY);
        this.myProxyAuthCheckBox.setSelected(httpConfigurable.PROXY_AUTHENTICATION);
        this.enableProxy(httpConfigurable.USE_HTTP_PROXY);
        this.myProxyLoginTextField.setText(httpConfigurable.PROXY_LOGIN);
        this.myProxyPasswordTextField.setText(httpConfigurable.getPlainProxyPassword());
        this.myProxyPortTextField.setText(Integer.toString(httpConfigurable.PROXY_PORT));
        this.myProxyHostTextField.setText(httpConfigurable.PROXY_HOST);
        this.myRememberProxyPasswordCheckBox.setSelected(httpConfigurable.KEEP_PROXY_PASSWORD);
    }

    public void apply() {
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        httpConfigurable.USE_HTTP_PROXY = this.myUseProxyCheckBox.isSelected();
        httpConfigurable.PROXY_AUTHENTICATION = this.myProxyAuthCheckBox.isSelected();
        httpConfigurable.KEEP_PROXY_PASSWORD = this.myRememberProxyPasswordCheckBox.isSelected();
        httpConfigurable.PROXY_LOGIN = this.myProxyLoginTextField.getText();
        httpConfigurable.setPlainProxyPassword(new String(this.myProxyPasswordTextField.getPassword()));
        try {
            httpConfigurable.PROXY_PORT = Integer.valueOf(this.myProxyPortTextField.getText());
        }
        catch (NumberFormatException e) {
            httpConfigurable.PROXY_PORT = 80;
        }
        httpConfigurable.PROXY_HOST = this.myProxyHostTextField.getText();
    }

    private void enableProxy(boolean enabled) {
        this.myHostNameLabel.setEnabled(enabled);
        this.myPortNumberLabel.setEnabled(enabled);
        this.myProxyHostTextField.setEnabled(enabled);
        this.myProxyPortTextField.setEnabled(enabled);
        this.myProxyAuthCheckBox.setEnabled(enabled);
        this.enableProxyAuthentication(enabled && this.myProxyAuthCheckBox.isSelected());
    }

    private void enableProxyAuthentication(boolean enabled) {
        this.myProxyPasswordLabel.setEnabled(enabled);
        this.myProxyLoginLabel.setEnabled(enabled);
        this.myProxyLoginTextField.setEnabled(enabled);
        this.myProxyPasswordTextField.setEnabled(enabled);
        this.myRememberProxyPasswordCheckBox.setEnabled(enabled);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JLabel jLabel2;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(5, 20, 10, 10), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHostNameLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.host.name"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myPortNumberLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.port.number"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myProxyHostTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyPortTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyAuthCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.proxy.authentication"));
        jCheckBox3.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox3.setSelected(false);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myProxyLoginTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyPasswordTextField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyLoginLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.login"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProxyPasswordLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.password"));
        jPanel2.add((Component)jLabel, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRememberProxyPasswordCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.remember.password"));
        jCheckBox2.setMargin(new Insets(2, 15, 2, 2));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUseProxyCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.use.http.proxy"));
        jCheckBox.setMargin(new Insets(2, 4, 2, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

