/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.CommonBundle;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.Nullable;

public class AuthenticationDialog
extends DialogWrapper {
    private AuthenticationPanel panel;

    public AuthenticationDialog(String title, String description) {
        super(JOptionPane.getRootFrame(), true);
        this.setTitle(title);
        new MnemonicHelper().register(this.getContentPane());
        this.panel = new AuthenticationPanel(description, HttpConfigurable.getInstance().PROXY_LOGIN, HttpConfigurable.getInstance().getPlainProxyPassword(), HttpConfigurable.getInstance().KEEP_PROXY_PASSWORD);
        Window window = this.getWindow();
        if (window instanceof JDialog) {
            ((JDialog)window).setDefaultCloseOperation(0);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    protected Action[] createActions() {
        Action[] actions = new Action[]{new AbstractAction(CommonBundle.getOkButtonText()){

            public void actionPerformed(ActionEvent e) {
                HttpConfigurable.getInstance().PROXY_LOGIN = AuthenticationDialog.this.panel.getLogin();
                HttpConfigurable.getInstance().setPlainProxyPassword(AuthenticationDialog.this.panel.getPassword());
                HttpConfigurable.getInstance().PROXY_AUTHENTICATION = true;
                HttpConfigurable.getInstance().KEEP_PROXY_PASSWORD = AuthenticationDialog.this.panel.isRememberPassword();
                AuthenticationDialog.this.dispose();
            }
        }, new AbstractAction(CommonBundle.getCancelButtonText()){

            public void actionPerformed(ActionEvent e) {
                HttpConfigurable.getInstance().PROXY_AUTHENTICATION = false;
                AuthenticationDialog.this.dispose();
            }
        }};
        actions[0].putValue("Default", Boolean.TRUE.toString());
        return actions;
    }
}

