/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages = new ThreadLocal<Queue<Message>>(){

        @Override
        protected Queue<Message> initialValue() {
            return new ConcurrentLinkedQueue<Message>();
        }
    };
    private MessageHandler myDefaultHandler;
    private Map<Topic, Object> mySubscriptions = new HashMap<Topic, Object>();

    public MessageBusConnectionImpl(MessageBusImpl bus) {
        this.myBus = bus;
    }

    @Override
    public <L> void subscribe(Topic<L> topic, L handler) {
        if (this.mySubscriptions.containsKey(topic)) {
            throw new IllegalStateException("Subscription to " + topic + " already exists");
        }
        this.mySubscriptions.put(topic, handler);
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public <L> void subscribe(Topic<L> topic) {
        if (this.mySubscriptions.containsKey(topic)) {
            throw new IllegalStateException("Subscription to " + topic + " already exists");
        }
        if (this.myDefaultHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions.");
        }
        this.mySubscriptions.put(topic, this.myDefaultHandler);
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public void setDefaultHandler(MessageHandler handler) {
        this.myDefaultHandler = handler;
    }

    @Override
    public void disconnect() {
        this.myBus.notifyConnectionTerminated(this);
    }

    @Override
    public void dispose() {
        this.disconnect();
    }

    @Override
    public void deliverImmediately() {
        while (!this.myPendingMessages.get().isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(Message message) {
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler = this.mySubscriptions.get(topic);
        if (handler == this.myDefaultHandler) {
            this.myDefaultHandler.handle(message.getListenerMethod(), message.getArgs());
        } else {
            try {
                message.getListenerMethod().invoke(handler, message.getArgs());
            }
            catch (AbstractMethodError e) {
            }
            catch (Throwable e) {
                LOG.error(e.getCause());
            }
        }
    }

    void scheduleMessageDelivery(Message message) {
        this.myPendingMessages.get().offer(message);
    }

    public String toString() {
        return this.mySubscriptions.keySet().toString();
    }
}

