/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassPath {
    private final Stack<URL> myUrls = new Stack();
    private ArrayList<Loader> myLoaders = new ArrayList();
    private HashMap<URL, Loader> myLoadersMap = new HashMap();
    private final ClasspathCache myCache = new ClasspathCache();
    @NonNls
    private static final String FILE_PROTOCOL = "file";
    private static boolean myDebugTime = false;
    private boolean myCanLockJars;
    private final boolean myCanUseCache;
    private static final long NS_THRESHOLD = 10000000L;

    public ClassPath(URL[] urls, boolean canLockJars, boolean canUseCache) {
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache;
        this.push(urls);
    }

    void addURL(URL url) {
        this.push(new URL[]{url});
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Resource getResource(String s, boolean flag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Enumeration<URL> getResources(String name, boolean check) {
        return new MyEnumeration(name, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            Loader loader;
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    return null;
                }
                url = this.myUrls.pop();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                loader = this.getLoader(url);
                if (loader == null) {
                }
            }
            catch (IOException ioexception) {}
            continue;
            this.myLoaders.add(loader);
            this.myLoadersMap.put(url, loader);
        }
        return this.myLoaders.get(i);
    }

    @Nullable
    private Loader getLoader(URL url) throws IOException {
        String s = url.getFile();
        Loader loader = null;
        if (s != null && new File(s).isDirectory()) {
            if (FILE_PROTOCOL.equals(url.getProtocol())) {
                loader = new FileLoader(url);
            }
        } else {
            loader = new JarLoader(url, this.myCanLockJars);
        }
        if (loader != null && this.myCanUseCache) {
            try {
                ((Loader)loader).buildCache(this.myCache);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] urls) {
        Stack<URL> stack = this.myUrls;
        synchronized (stack) {
            for (int i = urls.length - 1; i >= 0; --i) {
                this.myUrls.push(urls[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex = 0;
        private Resource myRes = null;
        private final String myName;
        private final boolean myCheck;

        public MyEnumeration(String name, boolean check) {
            this.myName = name;
            this.myCheck = check;
        }

        private boolean next() {
            Loader loader;
            if (this.myRes != null) {
                return true;
            }
            while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                this.myRes = loader.getResource(this.myName, this.myCheck);
                if (this.myRes == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

