/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.RecordDataOutput;
import com.intellij.util.io.storage.DataTable;
import com.intellij.util.io.storage.RecordsTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class Storage
implements Disposable,
Forceable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.Storage");
    private final Object lock = new Object();
    private final RecordsTable myRecordsTable;
    private DataTable myDataTable;

    public static boolean deleteFiles(String storageFilePath) {
        File recordsFile = new File(storageFilePath + ".rindex");
        File dataFile = new File(storageFilePath + ".data");
        return FileUtil.delete(recordsFile) && FileUtil.delete(dataFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Storage create(String storageFilePath) throws IOException {
        Storage storage;
        DataTable dataTable;
        File recordsFile = new File(storageFilePath + ".rindex");
        File dataFile = new File(storageFilePath + ".data");
        if (recordsFile.exists() != dataFile.exists()) {
            Storage.deleteFiles(storageFilePath);
        }
        if (!recordsFile.exists()) {
            recordsFile.getParentFile().mkdirs();
            recordsFile.createNewFile();
            dataFile.createNewFile();
        }
        RecordsTable recordsTable = null;
        try {
            recordsTable = new RecordsTable(recordsFile);
            dataTable = new DataTable(dataFile);
        }
        catch (IOException e) {
            boolean deleted;
            LOG.info(e.getMessage());
            if (recordsTable != null) {
                recordsTable.dispose();
            }
            if (!(deleted = Storage.deleteFiles(storageFilePath))) {
                throw new IOException("Can't delete caches at: " + storageFilePath);
            }
            storage = Storage.create(storageFilePath);
            if (storage == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/storage/Storage.create must not return null");
            return storage;
        }
        storage = new Storage(storageFilePath, recordsTable, dataTable);
        if (storage != null) return storage;
        throw new IllegalStateException("@NotNull method com/intellij/util/io/storage/Storage.create must not return null");
    }

    public Storage(String path, RecordsTable recordsTable, DataTable dataTable) {
        this.myRecordsTable = recordsTable;
        this.myDataTable = dataTable;
        if (this.myDataTable.isCompactNecessary()) {
            this.compact(path);
        }
    }

    public int getRecordsCount() {
        return this.myRecordsTable.getRecordsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(String path) {
        Object object = this.lock;
        synchronized (object) {
            LOG.info("Space waste in " + path + " is " + this.myDataTable.getWaste() + " bytes. Compacting now.");
            long start = System.currentTimeMillis();
            try {
                File newDataFile = new File(path + ".data.temp");
                FileUtil.delete(newDataFile);
                newDataFile.createNewFile();
                File oldDataFile = new File(path + ".data");
                DataTable newDataTable = new DataTable(newDataFile);
                int count = this.myRecordsTable.getRecordsCount();
                for (int i = 0; i < count; ++i) {
                    long addr = this.myRecordsTable.getAddress(i);
                    int size = this.myRecordsTable.getSize(i);
                    if (addr == 0L || size == 0) continue;
                    long newaddr = newDataTable.allocateSpace(size);
                    byte[] bytes = new byte[size];
                    this.myDataTable.readBytes(addr, bytes);
                    newDataTable.writeBytes(newaddr, bytes);
                    this.myRecordsTable.setAddress(i, newaddr);
                }
                this.myDataTable.dispose();
                newDataTable.dispose();
                if (!FileUtil.delete(oldDataFile)) {
                    throw new IOException("Can't delete file: " + oldDataFile);
                }
                newDataFile.renameTo(oldDataFile);
                this.myDataTable = new DataTable(oldDataFile);
            }
            catch (IOException e) {
                LOG.info("Compact failed: " + e.getMessage());
            }
            long timedelta = System.currentTimeMillis() - start;
            LOG.info("Done compacting in " + timedelta + "msec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.myRecordsTable.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(int expectedVersion) {
        Object object = this.lock;
        synchronized (object) {
            this.myRecordsTable.setVersion(expectedVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force() {
        Object object = this.lock;
        synchronized (object) {
            this.myDataTable.force();
            this.myRecordsTable.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.myDataTable.isDirty() || this.myRecordsTable.isDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNewRecord() {
        Object object = this.lock;
        synchronized (object) {
            return this.myRecordsTable.createNewRecord();
        }
    }

    public StorageDataOutput createStream() {
        return this.writeStream(this.createNewRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(int record, byte[] bytes) {
        Object object = this.lock;
        synchronized (object) {
            long address;
            int requiredLength = bytes.length;
            int currentSize = this.myRecordsTable.getSize(record);
            if (requiredLength == currentSize && currentSize == 0) {
                return;
            }
            if (currentSize >= requiredLength) {
                address = this.myRecordsTable.getAddress(record);
            } else {
                if (currentSize > 0) {
                    this.myDataTable.reclaimSpace(currentSize);
                }
                address = this.myDataTable.allocateSpace(requiredLength);
                this.myRecordsTable.setAddress(record, address);
            }
            this.myDataTable.writeBytes(address, bytes);
            this.myRecordsTable.setSize(record, requiredLength);
        }
    }

    public StorageDataOutput writeStream(int record) {
        return new StorageDataOutput(this, record);
    }

    public DataInputStream readStream(int record) {
        byte[] bytes = this.readBytes(record);
        return new DataInputStream(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int record) {
        Object object = this.lock;
        synchronized (object) {
            int length = this.myRecordsTable.getSize(record);
            if (length == 0) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            long address = this.myRecordsTable.getAddress(record);
            byte[] result = new byte[length];
            this.myDataTable.readBytes(address, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int record) {
        Object object = this.lock;
        synchronized (object) {
            int length = this.myRecordsTable.getSize(record);
            if (length != 0) {
                this.myDataTable.reclaimSpace(length);
            }
            this.myRecordsTable.deleteRecord(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.myRecordsTable.dispose();
            this.myDataTable.dispose();
        }
    }

    public static class StorageDataOutput
    extends DataOutputStream
    implements RecordDataOutput {
        private final Storage myStorage;
        private final int myRecordId;

        public StorageDataOutput(Storage storage, int recordId) {
            super(new ByteArrayOutputStream());
            this.myStorage = storage;
            this.myRecordId = recordId;
        }

        public void close() throws IOException {
            super.close();
            this.myStorage.writeBytes(this.myRecordId, ((ByteArrayOutputStream)this.out).toByteArray());
        }

        public int getRecordId() {
            return this.myRecordId;
        }
    }
}

