/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.util.io.RandomAccessDataFile;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;

class RecordsTable
implements Disposable,
Forceable {
    private static final int FIRST_RECORD = 1;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int RECORD_SIZE = 12;
    private static final byte[] ZEROES = new byte[12];
    private final RandomAccessDataFile myStorage;
    private TIntArrayList myFreeRecordsList = null;
    private boolean myIsDirty = false;

    public RecordsTable(File storageFilePath) throws IOException {
        this.myStorage = new RandomAccessDataFile(storageFilePath);
        if (this.myStorage.length() == 0L) {
            this.cleanRecord(0);
            this.myIsDirty = true;
        } else if (this.myStorage.getInt(0L) != 523190095) {
            this.myStorage.dispose();
            throw new IOException("Records table for '" + storageFilePath + "' haven't been closed correctly. Rebuild required.");
        }
    }

    private void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.myStorage.putInt(0L, 313341156);
        }
    }

    public int createNewRecord() {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        if (this.myFreeRecordsList.isEmpty()) {
            int filelength = (int)this.myStorage.length();
            assert (filelength % 12 == 0);
            int result = filelength / 12;
            this.cleanRecord(result);
            return result;
        }
        return this.myFreeRecordsList.remove(this.myFreeRecordsList.size() - 1);
    }

    private void ensureFreeRecordsScanned() {
        if (this.myFreeRecordsList == null) {
            this.myFreeRecordsList = this.scanForFreeRecords();
        }
    }

    private TIntArrayList scanForFreeRecords() {
        int filelength = (int)this.myStorage.length();
        assert (filelength % 12 == 0);
        TIntArrayList result = new TIntArrayList();
        int lastRecord = filelength / 12;
        for (int i = 1; i < lastRecord; ++i) {
            if (this.getAddress(i) != 0L) continue;
            result.add(i);
        }
        return result;
    }

    private void cleanRecord(int record) {
        this.myStorage.put(record * 12, ZEROES, 0, 12);
    }

    public long getAddress(int record) {
        return this.myStorage.getLong(record * 12 + 0);
    }

    public int getSize(int record) {
        return this.myStorage.getInt(record * 12 + 8);
    }

    public void setAddress(int record, long address) {
        this.markDirty();
        this.myStorage.putLong(record * 12 + 0, address);
    }

    public void setSize(int record, int size) {
        this.markDirty();
        this.myStorage.putInt(record * 12 + 8, size);
    }

    public void deleteRecord(int record) {
        this.ensureFreeRecordsScanned();
        this.cleanRecord(record);
        this.myFreeRecordsList.add(record);
    }

    public int getVersion() {
        return this.myStorage.getInt(4L);
    }

    public void setVersion(int expectedVersion) {
        this.markDirty();
        this.myStorage.putInt(4L, expectedVersion);
    }

    public void dispose() {
        this.markClean();
        this.myStorage.dispose();
    }

    public void force() {
        this.markClean();
        this.myStorage.force();
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myStorage.putInt(0L, 523190095);
        }
    }

    public int getRecordsCount() {
        return (int)(this.myStorage.length() / 12L);
    }
}

