/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.util.io.RandomAccessDataFile;
import java.io.File;
import java.io.IOException;

class DataTable
implements Disposable,
Forceable {
    private static final int HEADER_SIZE = 32;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private final RandomAccessDataFile myFile;
    private volatile int myWasteSize;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_WASTE_SIZE_OFFSET = 4;
    private boolean myIsDirty = false;

    public DataTable(File filePath) throws IOException {
        this.myFile = new RandomAccessDataFile(filePath);
        if (this.myFile.length() == 0L) {
            this.fillInHeader(313341156, 0);
            this.myIsDirty = true;
        } else {
            this.readInHeader(filePath);
        }
    }

    public boolean isCompactNecessary() {
        return (double)this.myWasteSize / (double)this.myFile.length() > 0.25 && this.myWasteSize > 0x300000;
    }

    private void readInHeader(File filePath) throws IOException {
        int magic = this.myFile.getInt(0L);
        if (magic != 523190095) {
            this.myFile.dispose();
            throw new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
        }
        this.myWasteSize = this.myFile.getInt(4L);
    }

    private void fillInHeader(int magic, int wasteSize) {
        this.myFile.putInt(0L, magic);
        this.myFile.putInt(4L, wasteSize);
    }

    public void readBytes(long address, byte[] bytes) {
        this.myFile.get(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes) {
        this.markDirty();
        this.myFile.put(address, bytes, 0, bytes.length);
    }

    public long allocateSpace(int len) {
        long result = Math.max(this.myFile.length(), 32L);
        this.writeBytes(result + (long)len - 1L, new byte[]{0});
        return result;
    }

    public void reclaimSpace(int len) {
        this.myWasteSize += len;
    }

    public void dispose() {
        this.markClean();
        this.myFile.dispose();
    }

    public void force() {
        this.markClean();
        this.myFile.force();
    }

    public boolean isDirty() {
        return this.myIsDirty || this.myFile.isDirty();
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.fillInHeader(523190095, this.myWasteSize);
        }
    }

    private void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.fillInHeader(313341156, 0);
        }
    }

    public int getWaste() {
        return this.myWasteSize;
    }
}

