/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.fs;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class IoFile
implements IFile {
    private final File myFile;

    public IoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/fs/IoFile.<init> must not be null");
        }
        this.myFile = file;
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    public byte[] loadBytes() throws IOException {
        return FileUtil.loadFileBytes(this.myFile);
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.myFile);
    }

    public OutputStream openOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.myFile);
    }

    public boolean delete() {
        return this.myFile.delete();
    }

    public void renameTo(IFile newFile) throws IOException {
        FileUtil.rename(this.myFile, ((IoFile)newFile).myFile);
    }

    public void createParentDirs() {
        FileUtil.createParentDirs(this.myFile);
    }

    public IFile getParentFile() {
        return new IoFile(this.myFile.getParentFile());
    }

    public String getName() {
        return this.myFile.getName();
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public String getCanonicalPath() {
        if (SystemInfo.isFileSystemCaseSensitive) {
            return this.myFile.getAbsolutePath();
        }
        try {
            return this.myFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getAbsolutePath() {
        return this.myFile.getAbsolutePath();
    }

    public long length() {
        return this.myFile.length();
    }

    public IFile getChild(String childName) {
        return new IoFile(new File(this.myFile, childName));
    }

    public boolean isDirectory() {
        return this.myFile.isDirectory();
    }

    public IFile[] listFiles() {
        File[] files = this.myFile.listFiles();
        IFile[] result = new IoFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new IoFile(files[i]);
        }
        return result;
    }

    public void mkDir() {
        this.myFile.mkdir();
    }

    public long getTimeStamp() {
        return this.myFile.lastModified();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoFile ioFile = (IoFile)o;
        return this.myFile.equals(ioFile.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return this.myFile.toString();
    }
}

