/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class URLUtil {
    private URLUtil() {
    }

    @NotNull
    public static InputStream openStream(URL url) throws IOException {
        InputStream inputStream;
        String protocol = url.getProtocol();
        if (!(protocol.equals("jar") ? (inputStream = URLUtil.openJarStream(url)) != null : (inputStream = url.openStream()) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openStream must not return null");
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static InputStream openJarStream(URL url) throws IOException {
        String file = url.getFile();
        assert (file.startsWith("file:"));
        file = file.substring("file:".length());
        assert (file.indexOf("!/") > 0);
        String resource = file.substring(file.indexOf("!/") + 2);
        final ZipFile zipFile = new ZipFile(FileUtil.unquote(file = file.substring(0, file.indexOf("!"))));
        ZipEntry zipEntry = zipFile.getEntry(resource);
        if (zipEntry == null) {
            throw new FileNotFoundException("Entry " + resource + " not found in " + file);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
        if (filterInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/URLUtil.openJarStream must not return null");
        }
        return filterInputStream;
    }
}

