/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.ObjectCache;
import com.intellij.util.io.CachedFile;
import com.intellij.util.io.CachedFilePage;
import com.intellij.util.io.CachingStrategy;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class SharedCachingStrategy
implements CachingStrategy {
    private final int myPageSize;
    private final ObjectCache<CachedPageKey, CachedFilePage> myCache;
    private final THashSet<CachedPageKey> myDirtyPages;
    private CachedFilePage myLastAccessedPage;
    private CachedFilePage myFreePage;
    private CachedPageKey mySearchKey;

    public SharedCachingStrategy(int desiredPageSize, int cacheSize) {
        this.myPageSize = SharedCachingStrategy.adjustPageSize(desiredPageSize, cacheSize);
        int pageCount = cacheSize / this.myPageSize;
        this.myCache = new ObjectCache(pageCount);
        this.myDirtyPages = new THashSet();
        this.mySearchKey = new CachedPageKey(null, 0);
        this.myCache.addDeletedPairsListener(new ObjectCache.DeletedPairsListener(){

            public void objectRemoved(Object key, Object value) {
                SharedCachingStrategy.this.myFreePage = (CachedFilePage)value;
            }
        });
    }

    public synchronized CachedFilePage getPage(CachedFile owner, long offset) throws IOException {
        offset -= offset % (long)this.myPageSize;
        if (this.myLastAccessedPage != null && owner == this.myLastAccessedPage.getOwner() && offset == this.myLastAccessedPage.getOffset()) {
            return this.myLastAccessedPage;
        }
        this.mySearchKey.setIdentity(owner, (int)(offset / (long)this.myPageSize));
        CachedFilePage result = this.myCache.tryKey(this.mySearchKey);
        if (result == null) {
            if (this.myFreePage == null) {
                result = new CachedFilePage(owner, offset, this.myPageSize);
            } else {
                result = this.myFreePage;
                result.setOwner(owner);
                result.setOffset(offset);
                this.myFreePage = null;
            }
            long bytes2End = owner.length() - offset;
            if (bytes2End < 0L) {
                bytes2End = 0L;
            }
            result.setSize(bytes2End >= (long)this.myPageSize ? this.myPageSize : (int)bytes2End);
            result.load();
            this.myCache.cacheObject(this.mySearchKey.cloneKey(), result);
            if (this.myFreePage != null) {
                this.myFreePage.save();
            }
        }
        this.myLastAccessedPage = result;
        return this.myLastAccessedPage;
    }

    public synchronized void markPageDirty(CachedFilePage page, boolean dirty) {
        this.mySearchKey.setIdentity(page.getOwner(), (int)(page.getOffset() / (long)this.myPageSize));
        if (!dirty) {
            this.myDirtyPages.remove((Object)this.mySearchKey);
        } else if (!this.myDirtyPages.contains((Object)this.mySearchKey)) {
            this.myDirtyPages.add((Object)this.mySearchKey.cloneKey());
        }
    }

    public synchronized void flush(CachedFile owner) throws IOException {
        if (this.myDirtyPages.size() > 0) {
            Object[] keys = this.myDirtyPages.toArray();
            if (keys.length > 1) {
                Arrays.sort(keys);
            }
            for (Object o : keys) {
                CachedFilePage page;
                CachedPageKey key = (CachedPageKey)o;
                if (owner != null && key.myOwner != owner || (page = this.myCache.tryKey(key)) == null) continue;
                page.save();
            }
        }
    }

    public synchronized void close(CachedFile owner) throws IOException {
        ArrayList<CachedFilePage> filePages = new ArrayList<CachedFilePage>();
        for (CachedFilePage page : this.myCache) {
            if (page == null || page.getOwner() != owner) continue;
            page.save();
            filePages.add(page);
        }
        for (CachedFilePage page : filePages) {
            this.mySearchKey.setIdentity(owner, (int)(page.getOffset() / (long)this.myPageSize));
            this.myCache.remove(this.mySearchKey);
        }
    }

    public void flush() throws IOException {
        this.flush(null);
    }

    public int getCacheSize() {
        return this.myCache.size();
    }

    public int getPageSize() {
        return this.myPageSize;
    }

    public synchronized int usedMemory() {
        return this.myCache.count() * this.myPageSize;
    }

    public synchronized double cacheHitRate() {
        return this.myCache.hitRate();
    }

    static int adjustPageSize(int desiredPageSize, int cacheSize) {
        double sqrt;
        if (desiredPageSize < 1024) {
            desiredPageSize = 1024;
        }
        if ((double)desiredPageSize < (sqrt = Math.sqrt(cacheSize))) {
            desiredPageSize = (int)sqrt;
            int remainder = desiredPageSize & 0x3FF;
            if (remainder != 0) {
                desiredPageSize += 1024;
            }
            desiredPageSize -= remainder;
        }
        return desiredPageSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedPageKey
    implements Comparable<CachedPageKey> {
        private CachedFile myOwner;
        private int myOffset;

        CachedPageKey(CachedFile owner, int offset) {
            this.setIdentity(owner, offset);
        }

        private void setIdentity(CachedFile owner, int offset) {
            this.myOwner = owner;
            this.myOffset = offset;
        }

        public CachedPageKey cloneKey() {
            return new CachedPageKey(this.myOwner, this.myOffset);
        }

        public boolean equals(Object o) {
            if (o instanceof CachedPageKey) {
                CachedPageKey right = (CachedPageKey)o;
                return right.myOwner == this.myOwner && right.myOffset == this.myOffset;
            }
            return false;
        }

        public int hashCode() {
            return this.myOwner.hashCode() + this.myOffset;
        }

        @Override
        public int compareTo(CachedPageKey right) {
            int comp = right.myOwner.hashCode() - this.myOwner.hashCode();
            if (comp == 0) {
                if (right.myOwner != this.myOwner) {
                    return this.myOwner.hashCode();
                }
                comp = this.myOffset - right.myOffset;
            }
            return comp;
        }
    }
}

