/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ReplicatorInputStream
extends InputStream {
    private final OutputStream myTarget;
    private final InputStream mySource;
    private int myBytesRead = 0;

    public ReplicatorInputStream(InputStream source, OutputStream target) {
        this.mySource = source;
        this.myTarget = target;
    }

    public int read() throws IOException {
        int b = this.mySource.read();
        if (b == -1) {
            return -1;
        }
        this.myTarget.write(b);
        ++this.myBytesRead;
        return b;
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] b) throws IOException {
        int count = this.mySource.read(b);
        if (count < 0) {
            return count;
        }
        this.myTarget.write(b, 0, count);
        this.myBytesRead += count;
        return count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.mySource.read(b, off, len);
        if (count < 0) {
            return count;
        }
        this.myTarget.write(b, off, count);
        this.myBytesRead += count;
        return count;
    }

    public long skip(long n) throws IOException {
        int skipped = this.read(new byte[(int)n]);
        this.myBytesRead += skipped;
        return skipped;
    }

    public int available() throws IOException {
        return this.mySource.available();
    }

    public void close() throws IOException {
        this.mySource.close();
        this.myTarget.close();
    }

    public int getBytesRead() {
        return this.myBytesRead;
    }
}

