/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.MappedBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NonNls;

public class ReadWriteMappedBufferWrapper
extends MappedBufferWrapper {
    @NonNls
    private static final String RW = "rw";

    public ReadWriteMappedBufferWrapper(File file) {
        super(file, 0L, file.length());
    }

    public ReadWriteMappedBufferWrapper(File file, int offset, int len) {
        super(file, offset, len);
    }

    public MappedByteBuffer map() {
        MappedByteBuffer buf;
        try {
            RandomAccessFile raf = new RandomAccessFile(this.myFile, RW);
            FileChannel channel = raf.getChannel();
            buf = null;
            try {
                buf = channel.map(FileChannel.MapMode.READ_WRITE, this.myPosition, this.myLength);
            }
            catch (IOException e) {
                throw new RuntimeException("Mapping failed: " + this.myFile.getAbsolutePath(), e);
            }
            finally {
                channel.close();
                raf.close();
            }
        }
        catch (IOException e) {
            buf = null;
        }
        if (buf == null) {
            throw new RuntimeException("Mapping failed: " + this.myFile.getAbsolutePath());
        }
        return buf;
    }
}

