/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.MappedBufferWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ReadOnlyMappedBufferWrapper
extends MappedBufferWrapper {
    public ReadOnlyMappedBufferWrapper(File file, int pos) {
        super(file, pos, file.length() - (long)pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map() {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream stream = new FileInputStream(this.myFile);
        FileChannel channel = stream.getChannel();
        try {
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, this.myPosition, this.myLength);
        }
        catch (Throwable throwable) {
            try {
                channel.close();
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Mapping failed for: " + this.myFile.getPath(), e);
            }
        }
        channel.close();
        stream.close();
        return mappedByteBuffer;
    }
}

