/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class RandomAccessDataFile
implements Forceable {
    private static final PagePool ourPool = new PagePool();
    private static int ourFilesCount = 0;
    private final int myCount = ourFilesCount++;
    private boolean myIsDirty = false;
    private final byte[] myTypedIOBuffer = new byte[8];
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, "rw");
    private long mySize;
    private final File myFile;

    public RandomAccessDataFile(File file) throws IOException {
        this.myFile = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " does not exist");
        }
        this.mySize = file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long addr, byte[] bytes, int off, int len) {
        block10: {
            this.myIsDirty = true;
            this.mySize = Math.max(this.mySize, addr + (long)len);
            if (len > 8192) {
                try {
                    ourPool.flushPagesInRange(this, addr, len);
                    RandomAccessFile file = this.getFile();
                    try {
                        RandomAccessFile randomAccessFile = file;
                        synchronized (randomAccessFile) {
                            file.seek(addr);
                            file.write(bytes, off, len);
                            break block10;
                        }
                    }
                    finally {
                        this.releaseFile();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            while (len > 0) {
                Page page = ourPool.alloc(this, addr);
                int written = page.put(addr, bytes, off, len);
                len -= written;
                addr += (long)written;
                off += written;
                ourPool.reclaim(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long addr, byte[] bytes, int off, int len) {
        if (len > 8192) {
            try {
                ourPool.flushPagesInRange(this, addr, len);
                RandomAccessFile file = this.getFile();
                try {
                    RandomAccessFile randomAccessFile = file;
                    synchronized (randomAccessFile) {
                        file.seek(addr);
                        file.read(bytes, off, len);
                    }
                }
                finally {
                    this.releaseFile();
                }
                this.mySize = Math.max(this.mySize, addr + (long)len);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        while (len > 0) {
            Page page = ourPool.alloc(this, addr);
            int read = page.get(addr, bytes, off, len);
            len -= read;
            addr += (long)read;
            off += read;
            ourPool.reclaim(page);
        }
    }

    private void releaseFile() {
        ourCache.releaseChannel(this.myFile);
    }

    private RandomAccessFile getFile() throws FileNotFoundException {
        return ourCache.getChannel(this.myFile);
    }

    public void putInt(long addr, int value) {
        byte[] buffer = this.myTypedIOBuffer;
        buffer[0] = (byte)(value >>> 24 & 0xFF);
        buffer[1] = (byte)(value >>> 16 & 0xFF);
        buffer[2] = (byte)(value >>> 8 & 0xFF);
        buffer[3] = (byte)(value & 0xFF);
        this.put(addr, buffer, 0, 4);
    }

    public int getInt(long addr) {
        byte[] buffer = this.myTypedIOBuffer;
        this.get(addr, buffer, 0, 4);
        int ch1 = buffer[0] & 0xFF;
        int ch2 = buffer[1] & 0xFF;
        int ch3 = buffer[2] & 0xFF;
        int ch4 = buffer[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public void putLong(long addr, long value) {
        byte[] buffer = this.myTypedIOBuffer;
        buffer[0] = (byte)(value >>> 56 & 0xFFL);
        buffer[1] = (byte)(value >>> 48 & 0xFFL);
        buffer[2] = (byte)(value >>> 40 & 0xFFL);
        buffer[3] = (byte)(value >>> 32 & 0xFFL);
        buffer[4] = (byte)(value >>> 24 & 0xFFL);
        buffer[5] = (byte)(value >>> 16 & 0xFFL);
        buffer[6] = (byte)(value >>> 8 & 0xFFL);
        buffer[7] = (byte)(value & 0xFFL);
        this.put(addr, buffer, 0, 8);
    }

    public void putByte(long addr, byte b) {
        this.myTypedIOBuffer[0] = b;
        this.put(addr, this.myTypedIOBuffer, 0, 1);
    }

    public byte getByte(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 1);
        return this.myTypedIOBuffer[0];
    }

    public String getUTF(long addr) {
        try {
            int len = this.getInt(addr);
            byte[] bytes = new byte[len];
            this.get(addr + 4L, bytes, 0, len);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void putUTF(long addr, String value) {
        try {
            byte[] bytes = value.getBytes("UTF-8");
            this.putInt(addr, bytes.length);
            this.put(addr + 4L, bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    public long getLong(long addr) {
        byte[] buffer = this.myTypedIOBuffer;
        this.get(addr, buffer, 0, 8);
        long ch1 = buffer[0] & 0xFF;
        long ch2 = buffer[1] & 0xFF;
        long ch3 = buffer[2] & 0xFF;
        long ch4 = buffer[3] & 0xFF;
        long ch5 = buffer[4] & 0xFF;
        long ch6 = buffer[5] & 0xFF;
        long ch7 = buffer[6] & 0xFF;
        long ch8 = buffer[7] & 0xFF;
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
    }

    public long length() {
        return this.mySize;
    }

    public void dispose() {
        ourPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
    }

    public void force() {
        if (this.isDirty()) {
            ourPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPage(Page page) {
        try {
            RandomAccessFile file = this.getFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    file.seek(page.getOffset());
                    ByteBuffer buf = page.getBuf();
                    file.read(buf.array(), 0, 8192);
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flushPage(Page page) {
        try {
            this.flush(page.getBuf(), page.getOffset(), 8192);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ByteBuffer buf, long offset, int length) throws IOException {
        if (offset + (long)length > this.mySize) {
            length = (int)(this.mySize - offset);
        }
        RandomAccessFile file = this.getFile();
        try {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                file.seek(offset);
                file.write(buf.array(), 0, length);
            }
        }
        finally {
            this.releaseFile();
        }
    }

    public int hashCode() {
        return this.myCount;
    }
}

