/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.io.MappedFile;
import java.io.File;
import java.io.IOException;

public class PersistentStringEnumerator
implements Forceable {
    private MappedFile myStorage;
    private static final int FIRST_VECTOR_OFFSET = 4;
    private static final int DIRTY_MAGIC = -1161951863;
    private static final int CORRECTLY_CLOSED_MAGIC = -341069908;
    private static final int STRING_HEADER_SIZE = 9;
    private static final int BITS_PER_LEVEL = 4;
    private static final int SLOTS_PER_VECTOR = 16;
    private static final int LEVEL_MASK = 15;
    private static final byte[] EMPTY_VECTOR = new byte[64];
    private byte[] buffer = new byte[264];
    private boolean myClosed = false;
    private boolean myDirty = false;

    public PersistentStringEnumerator(File file) throws IOException {
        this(file, 4096);
    }

    public PersistentStringEnumerator(File file, int initialSize) throws IOException {
        this.myStorage = new MappedFile(file, initialSize);
        if (this.myStorage.length() == 0L) {
            this.markDirty(true);
            this.allocVector();
        } else {
            int sign;
            try {
                sign = this.myStorage.getInt(0);
            }
            catch (Exception e) {
                sign = -1161951863;
            }
            if (sign != -341069908) {
                this.myStorage.close();
                throw new CorruptedException(file);
            }
        }
    }

    public synchronized int enumerate(String value) throws IOException {
        int newId;
        block7: {
            int candidateHC;
            int pos;
            int lastVector;
            int valueHC;
            int depth = 0;
            int hc = valueHC = value.hashCode();
            int vector = 4;
            do {
                lastVector = vector;
                pos = vector + (hc & 0xF) * 4;
                hc >>>= 4;
                vector = this.myStorage.getInt(pos);
                ++depth;
            } while (vector > 0);
            if (vector == 0) {
                int newId2 = this.writeNewString(value, valueHC);
                this.myStorage.putInt(pos, -newId2);
                return newId2;
            }
            int collision = -vector;
            boolean splitVector = false;
            do {
                if ((candidateHC = this.hashCodeOf(collision)) != valueHC) {
                    splitVector = true;
                    break;
                }
                String candidate = this.valueOf(collision);
                if (!value.equals(candidate)) continue;
                return collision;
            } while ((collision = this.nextCanditate(collision)) != 0);
            newId = this.writeNewString(value, valueHC);
            if (splitVector) {
                --depth;
                while (true) {
                    int oldHCByte;
                    int valueHCByte;
                    if ((valueHCByte = PersistentStringEnumerator.hcByte(valueHC, depth)) != (oldHCByte = PersistentStringEnumerator.hcByte(candidateHC, depth))) {
                        this.myStorage.putInt(lastVector + valueHCByte * 4, -newId);
                        this.myStorage.putInt(lastVector + oldHCByte * 4, vector);
                        break block7;
                    }
                    int newVector = this.allocVector();
                    this.myStorage.putInt(lastVector + oldHCByte * 4, newVector);
                    lastVector = newVector;
                    ++depth;
                }
            }
            this.myStorage.putInt(newId, vector);
            this.myStorage.putInt(pos, -newId);
        }
        return newId;
    }

    private static int hcByte(int hashcode, int byteN) {
        return hashcode >>> byteN * 4 & 0xF;
    }

    private int allocVector() throws IOException {
        int pos = (int)this.myStorage.length();
        this.myStorage.seek(pos);
        this.myStorage.put(EMPTY_VECTOR, 0, EMPTY_VECTOR.length);
        return pos;
    }

    private int nextCanditate(int idx) throws IOException {
        return -this.myStorage.getInt(idx);
    }

    private static boolean isAscii(String str) {
        for (int i = 0; i != str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0000' && c < '\u0080') continue;
            return false;
        }
        return true;
    }

    private int writeNewString(String value, int hashCode) {
        try {
            this.markDirty(true);
            MappedFile storage = this.myStorage;
            int pos = (int)storage.length();
            storage.seek(pos);
            int len = value.length();
            if (len < 255 && PersistentStringEnumerator.isAscii(value)) {
                byte[] buf = this.buffer;
                buf[3] = 0;
                buf[2] = 0;
                buf[1] = 0;
                buf[0] = 0;
                buf[7] = (byte)(hashCode & 0xFF);
                buf[6] = (byte)((hashCode >>>= 8) & 0xFF);
                buf[5] = (byte)((hashCode >>>= 8) & 0xFF);
                buf[4] = (byte)((hashCode >>>= 8) & 0xFF);
                buf[8] = (byte)len;
                for (int i = 0; i < len; ++i) {
                    buf[i + 9] = (byte)value.charAt(i);
                }
                storage.put(buf, 0, len + 9);
            } else {
                storage.writeInt(0);
                storage.writeInt(hashCode);
                storage.writeByte((byte)-1);
                storage.writeUTF(value);
            }
            return pos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCodeOf(int idx) throws IOException {
        return this.myStorage.getInt(idx + 4);
    }

    public synchronized String valueOf(int idx) throws IOException {
        String result;
        MappedFile storage = this.myStorage;
        storage.seek(idx + 8);
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            result = storage.readUTF();
        } else {
            byte[] buf = this.buffer;
            storage.get(buf, 0, len);
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)buf[i];
            }
            result = new String(chars);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.myClosed) {
            this.myClosed = true;
            try {
                this.flush();
            }
            finally {
                this.myStorage.close();
            }
        }
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public void flush() throws IOException {
        if (this.myStorage.isMapped() || this.isDirty()) {
            this.markDirty(false);
            this.myStorage.flush();
        }
    }

    public void force() {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void markDirty(boolean dirty) throws IOException {
        if (this.myDirty) {
            if (!dirty) {
                this.myStorage.putInt(0, -341069908);
                this.myDirty = false;
            }
        } else if (dirty) {
            this.myStorage.putInt(0, -1161951863);
            this.myDirty = true;
        }
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(File file) {
            super("PersistentStringEnumerator storage corrupted " + file.getPath());
        }
    }
}

