/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.MappedBufferWrapper;
import com.intellij.util.io.ReadWriteMappedBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;

public final class PagedFileStorage {
    private static final int BUFFER_SIZE = 524288;
    private MappedBufferWrapper[] myBuffers = null;
    private final File myFile;
    private long mySize = -1L;
    @NonNls
    private static final String RW = "rw";

    public PagedFileStorage(File file) throws IOException {
        this.myFile = file;
    }

    private synchronized void map() throws IOException {
        this.mySize = this.myFile.length();
        int intSize = (int)this.mySize;
        this.myBuffers = new MappedBufferWrapper[intSize / 524288 + 1];
        for (int i = 0; i < this.myBuffers.length; ++i) {
            int offset = i * 524288;
            if (offset >= intSize) continue;
            this.myBuffers[i] = new ReadWriteMappedBufferWrapper(this.myFile, offset, Math.min(intSize - offset, 524288));
        }
    }

    public short getShort(int index) {
        int page = index / 524288;
        int offset = index % 524288;
        return this.getBuffer(page).getShort(offset);
    }

    public void putShort(int index, short value) {
        int page = index / 524288;
        int offset = index % 524288;
        this.getBuffer(page).putShort(offset, value);
    }

    public int getInt(int index) {
        int page = index / 524288;
        int offset = index % 524288;
        return this.getBuffer(page).getInt(offset);
    }

    public void putInt(int index, int value) {
        int page = index / 524288;
        int offset = index % 524288;
        this.getBuffer(page).putInt(offset, value);
    }

    public byte get(int index) {
        int page = index / 524288;
        int offset = index % 524288;
        return this.getBuffer(page).get(offset);
    }

    public void put(int index, byte value) {
        int page = index / 524288;
        int offset = index % 524288;
        this.getBuffer(page).put(offset, value);
    }

    public void get(int index, byte[] dst, int offset, int length) {
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / 524288;
            int page_offset = i % 524288;
            int page_len = Math.min(l, 524288 - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            buffer.position(page_offset);
            buffer.get(dst, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    public void put(int index, byte[] src, int offset, int length) {
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / 524288;
            int page_offset = i % 524288;
            int page_len = Math.min(l, 524288 - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            buffer.position(page_offset);
            buffer.put(src, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    public void close() {
        this.unmap();
    }

    public void resize(int newSize) throws IOException {
        int oldSize = (int)this.myFile.length();
        if (oldSize == newSize) {
            return;
        }
        this.unmap();
        this.resizeFile(newSize);
        this.map();
        int delta = newSize - oldSize;
        if (delta > 0) {
            this.fillWithZeros(oldSize, delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeFile(int newSzie) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.myFile, RW);
        try {
            raf.setLength(newSzie);
        }
        finally {
            raf.close();
        }
    }

    private void fillWithZeros(int from, int length) {
        byte[] buff = new byte[length];
        Arrays.fill(buff, (byte)0);
        this.put(from, buff, 0, buff.length);
    }

    public final synchronized long length() {
        if (this.mySize == -1L) {
            try {
                this.map();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mySize;
    }

    private synchronized void unmap() {
        if (this.myBuffers != null) {
            for (int i = 0; i < this.myBuffers.length; ++i) {
                MappedBufferWrapper buffer = this.myBuffers[i];
                if (buffer == null) continue;
                buffer.dispose();
                this.myBuffers[i] = null;
            }
        }
    }

    private ByteBuffer getBuffer(int page) {
        return this.myBuffers[page].buf();
    }

    public void flush() {
        for (MappedBufferWrapper wrapper : this.myBuffers) {
            wrapper.flush();
        }
    }
}

