/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Page;
import com.intellij.util.io.RandomAccessDataFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagePool {
    private static final int PAGES_COUNT = 50;
    private final Object nonIOlock = new Object();
    private final Object iolock = new Object();
    private final PoolKey keyInstance = new PoolKey(null, -1L);
    private final Map<PoolKey, Page> myPages = new HashMap<PoolKey, Page>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Page alloc(RandomAccessDataFile owner, long offset) {
        Page page;
        Page page2;
        Page page3 = this.hitCache(owner, offset);
        if (page3 != null) {
            page2 = page3;
            if (page2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/PagePool.alloc must not return null");
            return page2;
        }
        Object object = this.iolock;
        synchronized (object) {
            page3 = this.hitCache(owner, offset);
            if (page3 != null) {
                Page page4 = page3;
                // MONITOREXIT @DISABLED, blocks:[3, 10] lbl11 : MonitorExitStatement: MONITOREXIT : var5_4
                page2 = page4;
                if (page4 == null) throw new IllegalStateException("@NotNull method com/intellij/util/io/PagePool.alloc must not return null");
                return page2;
            }
            this.dropLeastUsed();
            offset -= offset % 8192L;
            page3 = new Page(owner, offset);
            Object object2 = this.nonIOlock;
            synchronized (object2) {
                this.myPages.put(new PoolKey(owner, offset), page3);
                page3.lock();
            }
            page = page3;
        }
        page2 = page;
        if (page != null) return page2;
        throw new IllegalStateException("@NotNull method com/intellij/util/io/PagePool.alloc must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Page hitCache(RandomAccessDataFile owner, long offset) {
        Object object = this.nonIOlock;
        synchronized (object) {
            offset -= offset % 8192L;
            this.keyInstance.setup(owner, offset);
            Page page = this.myPages.get(this.keyInstance);
            if (page != null) {
                if (page.isLocked()) {
                    return null;
                }
                page.lock();
            }
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropLeastUsed() {
        while (true) {
            Page minPage = null;
            Object object = this.nonIOlock;
            synchronized (object) {
                if (this.myPages.size() < 50) {
                    return;
                }
                long minUsageCount = Long.MAX_VALUE;
                for (Page page : this.myPages.values()) {
                    if (page.isLocked() || page.getPageAccessCount() >= minUsageCount) continue;
                    minUsageCount = page.getPageAccessCount();
                    minPage = page;
                }
            }
            if (minPage == null) continue;
            this.dropPage(minPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPage(Page page) {
        Object object = this.iolock;
        synchronized (object) {
            Object object2 = this.nonIOlock;
            synchronized (object2) {
                if (page.isLocked()) {
                    return;
                }
                page.lock();
            }
            page.flush();
            object2 = this.nonIOlock;
            synchronized (object2) {
                this.keyInstance.setup(page.getOwner(), page.getOffset());
                this.myPages.remove(this.keyInstance);
                page.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPagesInRange(RandomAccessDataFile owner, long start, int length) {
        ArrayList<Page> pagesToDrop = new ArrayList<Page>();
        Object object = this.nonIOlock;
        synchronized (object) {
            for (Page page : this.myPages.values()) {
                if (!page.intersects(owner, start, length)) continue;
                pagesToDrop.add(page);
            }
        }
        object = this.iolock;
        synchronized (object) {
            for (Page page : pagesToDrop) {
                this.dropPage(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPages(RandomAccessDataFile owner) {
        ArrayList<Page> pagesToDrop = new ArrayList<Page>();
        Object object = this.nonIOlock;
        synchronized (object) {
            for (Page page : this.myPages.values()) {
                if (page.getOwner() != owner) continue;
                pagesToDrop.add(page);
            }
        }
        object = this.iolock;
        synchronized (object) {
            for (Page page : pagesToDrop) {
                this.dropPage(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaim(Page page) {
        Object object = this.nonIOlock;
        synchronized (object) {
            page.unlock();
        }
    }

    private static class PoolKey {
        private RandomAccessDataFile owner;
        private long offset;

        private PoolKey(RandomAccessDataFile owner, long offset) {
            this.owner = owner;
            this.offset = offset;
        }

        public int hashCode() {
            return (int)((long)(this.owner.hashCode() * 31) + this.offset);
        }

        public boolean equals(Object obj) {
            PoolKey k = (PoolKey)obj;
            return k.owner == this.owner && k.offset == this.offset;
        }

        public void setup(RandomAccessDataFile owner, long offset) {
            this.owner = owner;
            this.offset = offset;
        }
    }
}

