/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.RandomAccessDataFile;
import java.nio.ByteBuffer;

public class Page {
    public static final int PAGE_SIZE = 8192;
    private final ByteBuffer buf = ByteBuffer.allocate(8192);
    private final long offset;
    private final RandomAccessDataFile owner;
    private boolean dirty = false;
    private static long totalAccessCount = 0L;
    private long pageAccessCount = 0L;
    private boolean myIsLocked = false;

    public Page(RandomAccessDataFile owner, long offset) {
        this.owner = owner;
        this.offset = offset;
        assert (offset >= 0L);
        this.touch(false);
        owner.loadPage(this);
    }

    public boolean intersects(RandomAccessDataFile anotherOwner, long anotherOffset, int anotherLen) {
        if (anotherOwner != this.owner) {
            return false;
        }
        return Math.max(this.offset, anotherOffset) <= Math.min(this.offset + (long)this.buf.limit(), anotherOffset + (long)anotherLen);
    }

    public void flush() {
        if (this.dirty) {
            this.owner.flushPage(this);
            this.dirty = false;
        }
    }

    public long getPageAccessCount() {
        return this.pageAccessCount;
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public long getOffset() {
        return this.offset;
    }

    private void touch(boolean write) {
        this.pageAccessCount = ++totalAccessCount;
        this.dirty |= write;
    }

    public int put(long index, byte[] bytes, int off, int length) {
        this.touch(true);
        int start = (int)(index - this.offset);
        this.buf.position(start);
        int count = Math.min(length, 8192 - start);
        this.buf.put(bytes, off, count);
        return count;
    }

    public int get(long index, byte[] bytes, int off, int length) {
        this.touch(false);
        int start = (int)(index - this.offset);
        this.buf.position(start);
        int count = Math.min(length, 8192 - start);
        this.buf.get(bytes, off, count);
        return count;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public void lock() {
        this.myIsLocked = true;
    }

    public void unlock() {
        this.myIsLocked = false;
    }

    public RandomAccessDataFile getOwner() {
        return this.owner;
    }
}

