/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimedComputable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedBufferWrapper
extends TimedComputable<ByteBuffer> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.MappedBufferWrapper");
    @NonNls
    public static final String BBU_TEMP_FILE_NAME = "BBU";
    @NonNls
    public static final String CLEANER_METHOD = "cleaner";
    @NonNls
    public static final String CLEAN_METHOD = "clean";
    @NonNls
    public static final String VIEWED_BUFFER_FIELD = "viewedBuffer";
    @NonNls
    public static final String FINALIZE_METHOD = "finalize";
    protected File myFile;
    protected long myPosition;
    protected long myLength;
    private static int totalSize = 0;

    public MappedBufferWrapper(File file, long pos, long length) {
        super(null);
        this.myFile = file;
        this.myPosition = pos;
        this.myLength = length;
    }

    protected abstract MappedByteBuffer map();

    public final void unmap() {
        totalSize = (int)((long)totalSize - this.myLength);
        if (!MappedBufferWrapper.unmapMappedByteBuffer142b19(this)) {
            MappedBufferWrapper.unmapMappedByteBuffer141(this);
        }
    }

    public ByteBuffer buf() {
        ByteBuffer buf = (ByteBuffer)this.acquire();
        this.acquire();
        this.release();
        this.release();
        return buf;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected ByteBuffer calc() {
        totalSize = (int)((long)totalSize + this.myLength);
        MappedByteBuffer mappedByteBuffer = this.map();
        if (mappedByteBuffer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/MappedBufferWrapper.calc must not return null");
        }
        return mappedByteBuffer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedBufferWrapper that = (MappedBufferWrapper)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (int)(this.myPosition ^ this.myPosition >>> 32);
        result = 31 * result + (int)(this.myLength ^ this.myLength >>> 32);
        return result;
    }

    private static void unmapMappedByteBuffer141(MappedBufferWrapper holder) {
        ByteBuffer buffer = (ByteBuffer)holder.getIfCached();
        MappedBufferWrapper.unmapBuffer(buffer);
        boolean needGC = SystemInfo.JAVA_VERSION.startsWith("1.4.0");
        if (!needGC) {
            try {
                File newFile = File.createTempFile(BBU_TEMP_FILE_NAME, "", holder.myFile.getParentFile());
                newFile.delete();
                if (!holder.myFile.renameTo(newFile)) {
                    needGC = true;
                } else {
                    newFile.renameTo(holder.myFile);
                }
            }
            catch (IOException e) {
                needGC = true;
            }
        }
        if (needGC) {
            System.gc();
            System.runFinalization();
        }
    }

    private static boolean unmapMappedByteBuffer142b19(MappedBufferWrapper holder) {
        return MappedBufferWrapper.clean(holder.getIfCached());
    }

    public static boolean clean(final Object buffer) {
        if (buffer == null) {
            return true;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod(MappedBufferWrapper.CLEANER_METHOD, ArrayUtil.EMPTY_CLASS_ARRAY);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke(buffer, ArrayUtil.EMPTY_OBJECT_ARRAY);
                    if (cleaner == null) {
                        return null;
                    }
                    Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
                    Method cleanMethod = cleanerClass.getMethod(MappedBufferWrapper.CLEAN_METHOD, ArrayUtil.EMPTY_CLASS_ARRAY);
                    cleanMethod.invoke(cleaner, ArrayUtil.EMPTY_OBJECT_ARRAY);
                }
                catch (Exception e) {
                    return buffer;
                }
                return null;
            }
        }) == null;
    }

    private static void unmapBuffer(ByteBuffer buffer) {
        try {
            Field field = Class.forName("java.nio.DirectByteBuffer").getDeclaredField(VIEWED_BUFFER_FIELD);
            field.setAccessible(true);
            if (field.get(buffer) instanceof MappedByteBuffer) {
                MappedBufferWrapper.unmapBuffer((MappedByteBuffer)field.get(buffer));
                return;
            }
            Method finalizeMethod = Object.class.getDeclaredMethod(FINALIZE_METHOD, ArrayUtil.EMPTY_CLASS_ARRAY);
            finalizeMethod.setAccessible(true);
            finalizeMethod.invoke((Object)buffer, ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    public synchronized boolean isMapped() {
        return this.getIfCached() != null;
    }

    public synchronized void flush() {
        ByteBuffer buffer = (ByteBuffer)this.getIfCached();
        if (buffer != null && buffer instanceof MappedByteBuffer) {
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)buffer;
            mappedByteBuffer.force();
        }
    }

    @Override
    public synchronized void dispose() {
        this.unmap();
        super.dispose();
    }
}

