/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.CachedFile;
import com.intellij.util.io.CachingStrategy;
import com.intellij.util.io.SharedCachingStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CachedRandomAccessFile
extends CachedFile {
    private RandomAccessFile myFile;

    public CachedRandomAccessFile(File file, int desiredPageSize, int cacheSize) throws FileNotFoundException, IOException {
        this.myFile = new RandomAccessFile(file, "rw");
        int pageSize = SharedCachingStrategy.adjustPageSize(desiredPageSize, cacheSize);
        int pageCount = cacheSize / pageSize;
        this.init(new CachedFile.SingleFileCachingStrategy(pageSize, pageCount), this.myFile.length(), this.myFile.getFilePointer());
    }

    public CachedRandomAccessFile(String name, int desiredPageSize, int cacheSize) throws FileNotFoundException, IOException {
        this(new File(name), desiredPageSize, cacheSize);
    }

    public CachedRandomAccessFile(File file, CachingStrategy strategy) throws FileNotFoundException, IOException {
        this.myFile = new RandomAccessFile(file, "rw");
        this.init(strategy, this.myFile.length(), this.myFile.getFilePointer());
    }

    public CachedRandomAccessFile(String name, CachingStrategy strategy) throws FileNotFoundException, IOException {
        this(new File(name), strategy);
    }

    public CachedRandomAccessFile(File file, int cacheSize) throws IOException {
        this(file, 4096, cacheSize);
    }

    void loadPage(long offset, byte[] page, int size) throws IOException {
        this.myFile.seek(offset);
        this.myFile.read(page, 0, size);
    }

    void savePage(long offset, byte[] page, int size) throws IOException {
        if (offset > this.myFile.length()) {
            this.myFile.setLength(offset);
        }
        this.myFile.seek(offset);
        this.myFile.write(page, 0, size);
    }

    public void flush() throws IOException {
        if (this.myFile != null) {
            super.flush();
        }
    }

    public void close() throws IOException {
        if (this.myFile != null) {
            super.close();
            this.myFile.close();
            this.myFile = null;
        }
    }
}

