/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.CachedFile;
import java.io.IOException;

class CachedFilePage {
    private CachedFile myOwner;
    private long myOffset;
    private int mySize;
    private final byte[] myPage;
    private boolean myIsDirty;

    public CachedFilePage(CachedFile owner, long offset, int pageSize) {
        this.myOwner = owner;
        this.myPage = new byte[pageSize];
        this.myOffset = offset;
    }

    protected void finalize() throws Throwable {
        this.save();
        super.finalize();
    }

    public CachedFile getOwner() {
        return this.myOwner;
    }

    public void setOwner(CachedFile owner) {
        this.myOwner = owner;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public void setOffset(long offset) {
        this.myOffset = offset;
    }

    public int getSize() {
        return this.mySize;
    }

    public void setSize(int size) {
        this.mySize = size;
    }

    public void load() throws IOException {
        if (this.mySize > 0) {
            this.myOwner.loadPage(this.myOffset, this.myPage, this.mySize);
        }
        this.myIsDirty = false;
    }

    public void save() throws IOException {
        if (this.myIsDirty) {
            if (this.mySize > 0) {
                this.myOwner.savePage(this.myOffset, this.myPage, this.mySize);
            }
            this.myOwner.markPageDirty(this, false);
            this.myIsDirty = false;
        }
    }

    public byte getByte(int index) {
        return this.myPage[index];
    }

    public void setByte(int index, byte b) {
        this.myPage[index++] = b;
        if (index > this.mySize) {
            this.mySize = index;
        }
        this.markDirty();
    }

    public int read(int sourceIndex, byte[] buffer, int destIndex, int count) {
        int bytesRead = count;
        if (sourceIndex + bytesRead > this.mySize) {
            bytesRead = this.mySize - sourceIndex;
        }
        System.arraycopy(this.myPage, sourceIndex, buffer, destIndex, bytesRead);
        return bytesRead;
    }

    public void write(byte[] buffer, int sourceIndex, int destIndex, int count) {
        System.arraycopy(buffer, sourceIndex, this.myPage, destIndex, count);
        if (this.mySize < destIndex + count) {
            this.mySize = destIndex + count;
        }
        this.markDirty();
    }

    private void markDirty() {
        if (!this.myIsDirty) {
            this.myOwner.markPageDirty(this, true);
            this.myIsDirty = true;
        }
    }
}

