/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.IntObjectCache;
import com.intellij.util.io.CachedFilePage;
import com.intellij.util.io.CachingStrategy;
import gnu.trove.TIntHashSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class CachedFile
implements DataOutput,
DataInput,
Flushable,
Closeable {
    @NonNls
    private static final String UTF_8_CHARSET_NAME = "UTF-8";
    private byte[] myTypedIOBuffer = new byte[8];
    protected long myLength;
    protected long myPosition;
    protected CachingStrategy myStrategy;

    abstract void loadPage(long var1, byte[] var3, int var4) throws IOException;

    abstract void savePage(long var1, byte[] var3, int var4) throws IOException;

    final void markPageDirty(CachedFilePage page, boolean dirty) {
        this.myStrategy.markPageDirty(page, dirty);
    }

    public final long getFilePointer() {
        return this.myPosition;
    }

    public final long length() {
        return this.myLength;
    }

    public final void seek(long pos) throws IOException {
        if (pos < 0L || pos > this.myLength) {
            throw new IOException("Invalid position: " + pos + ", length = " + this.myLength);
        }
        this.myPosition = pos;
    }

    public final int usedMemory() {
        return this.myStrategy.usedMemory();
    }

    public final double cacheHitRate() {
        return this.myStrategy.cacheHitRate();
    }

    public void write(int b) throws IOException {
        this.myStrategy.getPage(this, this.myPosition).setByte((int)(this.myPosition % (long)this.myStrategy.getPageSize()), (byte)b);
        if (++this.myPosition > this.myLength) {
            this.myLength = this.myPosition;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            CachedFilePage page = this.myStrategy.getPage(this, this.myPosition);
            int pageIndex = (int)(this.myPosition % (long)this.myStrategy.getPageSize());
            int pageBytes = this.myStrategy.getPageSize() - pageIndex;
            if (pageBytes > len) {
                pageBytes = len;
            }
            page.write(b, off, pageIndex, pageBytes);
            len -= pageBytes;
            off += pageBytes;
            this.myPosition += (long)pageBytes;
            if (this.myPosition <= this.myLength) continue;
            this.myLength = this.myPosition;
        }
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        buffer[0] = (byte)(v >>> 8 & 0xFF);
        buffer[1] = (byte)(v & 0xFF);
        this.write(buffer, 0, 2);
    }

    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public final void writeInt(int v) throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        buffer[0] = (byte)(v >>> 24 & 0xFF);
        buffer[1] = (byte)(v >>> 16 & 0xFF);
        buffer[2] = (byte)(v >>> 8 & 0xFF);
        buffer[3] = (byte)(v & 0xFF);
        this.write(buffer, 0, 4);
    }

    public final void writeLong(long v) throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        buffer[0] = (byte)(v >>> 56 & 0xFFL);
        buffer[1] = (byte)(v >>> 48 & 0xFFL);
        buffer[2] = (byte)(v >>> 40 & 0xFFL);
        buffer[3] = (byte)(v >>> 32 & 0xFFL);
        buffer[4] = (byte)(v >>> 24 & 0xFFL);
        buffer[5] = (byte)(v >>> 16 & 0xFFL);
        buffer[6] = (byte)(v >>> 8 & 0xFFL);
        buffer[7] = (byte)(v & 0xFFL);
        this.write(buffer, 0, 8);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    public final void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)c[i];
        }
        this.write(b);
    }

    public final void writeUTF(String str) throws IOException {
        byte[] bytes = str.getBytes(UTF_8_CHARSET_NAME);
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    public int read() throws IOException, EOFException {
        if (this.myPosition >= this.myLength) {
            throw new EOFException();
        }
        byte result = this.myStrategy.getPage(this, this.myPosition).getByte((int)(this.myPosition % (long)this.myStrategy.getPageSize()));
        ++this.myPosition;
        return result & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int savedOffset = off;
        while (len > 0 && this.myPosition < this.myLength) {
            CachedFilePage page = this.myStrategy.getPage(this, this.myPosition);
            int pageIndex = (int)(this.myPosition % (long)this.myStrategy.getPageSize());
            int readBytes = page.read(pageIndex, b, off, len);
            this.myPosition += (long)readBytes;
            off += readBytes;
            len -= readBytes;
        }
        return off - savedOffset;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        for (int n = 0; len > n; n += this.read(b, off + n, len - n)) {
            if (this.myPosition < this.myLength) continue;
            throw new EOFException("Position " + this.myPosition + " is out of file length " + this.myLength + ". Bytes to read: " + (len - n));
        }
    }

    public int skipBytes(int n) throws IOException {
        long len;
        if (n <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = pos + (long)n;
        if (newpos > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        return ch != 0;
    }

    public final byte readByte() throws IOException {
        int ch = this.read();
        return (byte)ch;
    }

    public final int readUnsignedByte() throws IOException {
        return this.read();
    }

    public final short readShort() throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        if (this.read(buffer, 0, 2) < 2) {
            throw new EOFException();
        }
        int ch1 = buffer[0] & 0xFF;
        int ch2 = buffer[1] & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    public final int readUnsignedShort() throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        if (this.read(buffer, 0, 2) < 2) {
            throw new EOFException();
        }
        int ch1 = buffer[0] & 0xFF;
        int ch2 = buffer[1] & 0xFF;
        return (ch1 << 8) + ch2;
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final int readInt() throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        if (this.read(buffer, 0, 4) < 4) {
            throw new EOFException();
        }
        int ch1 = buffer[0] & 0xFF;
        int ch2 = buffer[1] & 0xFF;
        int ch3 = buffer[2] & 0xFF;
        int ch4 = buffer[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public final long readLong() throws IOException {
        byte[] buffer = this.myTypedIOBuffer;
        if (this.read(buffer, 0, 8) < 8) {
            throw new EOFException();
        }
        long ch1 = buffer[0] & 0xFF;
        long ch2 = buffer[1] & 0xFF;
        long ch3 = buffer[2] & 0xFF;
        long ch4 = buffer[3] & 0xFF;
        long ch5 = buffer[4] & 0xFF;
        long ch6 = buffer[5] & 0xFF;
        long ch7 = buffer[6] & 0xFF;
        long ch8 = buffer[7] & 0xFF;
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Nullable
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public final String readUTF() throws IOException {
        int len = this.readInt();
        byte[] bytes = new byte[len];
        this.readFully(bytes);
        return new String(bytes, UTF_8_CHARSET_NAME);
    }

    public void flush() throws IOException {
        this.myStrategy.flush(this);
    }

    public void close() throws IOException {
        this.myStrategy.close(this);
    }

    public void dispose() throws IOException {
        this.close();
    }

    protected void init(CachingStrategy strategy, long length, long position) throws IOException {
        this.myLength = length;
        this.myPosition = position;
        this.myStrategy = strategy;
    }

    protected static class SingleFileCachingStrategy
    implements CachingStrategy {
        private final int myPageSize;
        private final IntObjectCache<CachedFilePage> myCache;
        private final TIntHashSet myDirtyPages;
        private CachedFilePage myLastAccessedPage;
        private CachedFilePage myFreePage;

        SingleFileCachingStrategy(int pageSize, int pagesCount) {
            this.myPageSize = pageSize;
            this.myCache = new IntObjectCache(pagesCount);
            this.myDirtyPages = new TIntHashSet();
            this.myCache.addDeletedPairsListener(new IntObjectCache.DeletedPairsListener(){

                public void objectRemoved(int key, Object value) {
                    SingleFileCachingStrategy.this.myFreePage = (CachedFilePage)value;
                }
            });
        }

        public CachedFilePage getPage(CachedFile owner, long offset) throws IOException {
            offset -= offset % (long)this.myPageSize;
            if (this.myLastAccessedPage != null && offset == this.myLastAccessedPage.getOffset()) {
                return this.myLastAccessedPage;
            }
            int pageOffset = (int)(offset / (long)this.myPageSize);
            CachedFilePage result = this.myCache.tryKey(pageOffset);
            if (result == null) {
                if (this.myFreePage == null) {
                    result = new CachedFilePage(owner, offset, this.myPageSize);
                } else {
                    result = this.myFreePage;
                    result.setOffset(offset);
                    this.myFreePage = null;
                }
                long bytes2End = owner.length() - offset;
                if (bytes2End < 0L) {
                    bytes2End = 0L;
                }
                result.setSize(bytes2End >= (long)this.myPageSize ? this.myPageSize : (int)bytes2End);
                result.load();
                this.myCache.cacheObject(pageOffset, result);
                if (this.myFreePage != null) {
                    this.myFreePage.save();
                }
            }
            this.myLastAccessedPage = result;
            return this.myLastAccessedPage;
        }

        public void markPageDirty(CachedFilePage page, boolean dirty) {
            int offset = (int)(page.getOffset() / (long)this.myPageSize);
            if (dirty) {
                this.myDirtyPages.add(offset);
            } else {
                this.myDirtyPages.remove(offset);
            }
        }

        public void flush(CachedFile owner) throws IOException {
            this.flush();
        }

        public void flush() throws IOException {
            if (this.myDirtyPages.size() > 0) {
                int[] ints = this.myDirtyPages.toArray();
                if (ints.length > 1) {
                    Arrays.sort(ints);
                }
                for (int offset : ints) {
                    CachedFilePage page = this.myCache.tryKey(offset);
                    if (page == null) continue;
                    page.save();
                }
            }
        }

        public void close(CachedFile owner) throws IOException {
            this.flush();
        }

        public int getCacheSize() {
            return this.myCache.size();
        }

        public int getPageSize() {
            return this.myPageSize;
        }

        public int usedMemory() {
            return this.myCache.count() * this.myPageSize;
        }

        public double cacheHitRate() {
            return this.myCache.hitRate();
        }
    }
}

