/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTree<OT, NT> {
    private static final int CHANGE_PARENT_VERSUS_CHILDREN_THRESHOLD = 20;
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final DiffTreeChangeBuilder<OT, NT> myConsumer;
    private final List<Ref<OT[]>> myOldChildrenLists = new ArrayList<Ref<OT[]>>();
    private final List<Ref<NT[]>> myNewChildrenLists = new ArrayList<Ref<NT[]>>();
    private final List<ThreeState[]> myDeepStates = new ArrayList<ThreeState[]>();

    public DiffTree(FlyweightCapableTreeStructure<OT> oldTree, FlyweightCapableTreeStructure<NT> newTree, ShallowNodeComparator<OT, NT> comparator, DiffTreeChangeBuilder<OT, NT> consumer) {
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myConsumer = consumer;
    }

    public static <OT, NT> void diff(FlyweightCapableTreeStructure<OT> oldTree, FlyweightCapableTreeStructure<NT> newTree, ShallowNodeComparator<OT, NT> comparator, DiffTreeChangeBuilder<OT, NT> consumer) {
        super.build(oldTree.getRoot(), newTree.getRoot(), 0);
    }

    private void build(OT oldN, NT newN, int level) {
        Object oldChild;
        Object newChild;
        Object oldChild2;
        int newEnd;
        Object newChild2;
        Object oldChild3;
        int start;
        ThreeState[] deeps;
        OT oldNode = this.myOldTree.prepareForGetChildren(oldN);
        NT newNode = this.myNewTree.prepareForGetChildren(newN);
        if (level >= this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldSize - newSize) > 20) {
            this.myConsumer.nodeReplaced(oldNode, newNode);
            this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
            return;
        }
        ShallowNodeComparator<Object, Object> comparator = this.myComparator;
        if (oldSize == 0 && newSize == 0) {
            if (!comparator.hashcodesEqual(oldNode, newNode) || !comparator.typesEqual(oldNode, newNode)) {
                this.myConsumer.nodeReplaced(oldNode, newNode);
            }
            this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
            return;
        }
        boolean walkedDeep = false;
        if (oldSize == newSize) {
            while (this.myDeepStates.size() <= level) {
                this.myDeepStates.add(new ThreeState[oldSize]);
            }
            deeps = this.myDeepStates.get(level);
            if (deeps.length < oldSize) {
                deeps = new ThreeState[oldSize];
                this.myDeepStates.set(level, deeps);
            } else {
                Arrays.fill((Object[])deeps, 0, oldSize, null);
            }
        } else {
            deeps = null;
        }
        for (start = 0; start < oldSize && start < newSize && comparator.typesEqual(oldChild3 = oldChildren[start], newChild2 = newChildren[start]); ++start) {
            ThreeState dp = comparator.deepEqual(oldChild3, newChild2);
            if (deeps != null) {
                deeps[start] = dp;
            }
            if (dp == ThreeState.YES) continue;
            if (!comparator.hashcodesEqual(oldChild3, newChild2)) break;
            if (dp == ThreeState.UNSURE) {
                this.build(oldChild3, newChild2, level + 1);
                walkedDeep = true;
                continue;
            }
            if (dp != ThreeState.NO) continue;
            this.myConsumer.nodeReplaced(oldChild3, newChild2);
        }
        int oldEnd = oldSize - 1;
        if (oldSize == newSize && start == newSize) {
            this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
            return;
        }
        for (newEnd = newSize - 1; oldEnd >= start && newEnd >= start && comparator.typesEqual(oldChild2 = oldChildren[oldEnd], newChild = newChildren[newEnd]); --oldEnd, --newEnd) {
            ThreeState dp = comparator.deepEqual(oldChild2, newChild);
            if (deeps != null) {
                deeps[oldEnd] = dp;
            }
            if (dp == ThreeState.YES) continue;
            if (!comparator.hashcodesEqual(oldChild2, newChild)) break;
            if (dp == ThreeState.UNSURE) {
                this.build(oldChild2, newChild, level + 1);
                walkedDeep = true;
                continue;
            }
            if (dp != ThreeState.NO) continue;
            this.myConsumer.nodeReplaced(oldChild2, newChild);
        }
        if (oldSize == newSize) {
            for (int i = start; i <= newEnd; ++i) {
                oldChild = oldChildren[i];
                Object newChild3 = newChildren[i];
                if (comparator.typesEqual(oldChild, newChild3)) {
                    ThreeState de = deeps[i];
                    if (de == ThreeState.UNSURE) {
                        this.build(oldChild, newChild3, level + 1);
                        continue;
                    }
                    if (de != ThreeState.NO && de != null) continue;
                    this.myConsumer.nodeReplaced(oldChild, newChild3);
                    continue;
                }
                this.myConsumer.nodeReplaced(oldChild, newChild3);
            }
        } else {
            int i;
            if (!walkedDeep && start == 0 && newEnd == newSize - 1 && oldEnd == oldSize - 1 && start < oldEnd && start < newEnd) {
                this.myConsumer.nodeReplaced(oldNode, newNode);
                this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
                return;
            }
            for (i = start; i <= oldEnd; ++i) {
                oldChild = oldChildren[i];
                this.myConsumer.nodeDeleted(oldNode, oldChild);
            }
            for (i = start; i <= newEnd; ++i) {
                this.myConsumer.nodeInserted(oldNode, newChildren[i], i);
            }
        }
        this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
    }

    private void disposeLevel(OT[] oldChildren, int oldSize, NT[] newChildren, int newSize) {
        this.myOldTree.disposeChildren(oldChildren, oldSize);
        this.myNewTree.disposeChildren(newChildren, newSize);
    }
}

