/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.FactoryMap;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeakFactoryMap<T, V> {
    private final ConcurrentMap<T, WeakReference<V>> myMap = new ConcurrentWeakHashMap<T, WeakReference<V>>();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v;
        WeakReference reference = (WeakReference)this.myMap.get(key);
        if (reference != null && (v = reference.get()) != null) {
            return v == FactoryMap.NULL ? null : (V)v;
        }
        V value = this.create(key);
        WeakReference<Object> valueRef = new WeakReference<Object>(value == null ? FactoryMap.NULL : value);
        WeakReference<Object> prevRef = this.myMap.putIfAbsent(key, valueRef);
        Object prev = prevRef == null ? null : prevRef.get();
        return (V)(prev == null || prev == FactoryMap.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

