/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.FactoryMap;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoftFactoryMap<T, V> {
    private final ConcurrentMap<T, SoftReference<V>> myMap = new ConcurrentWeakHashMap<T, SoftReference<V>>();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v;
        SoftReference reference = (SoftReference)this.myMap.get(key);
        if (reference != null && (v = reference.get()) != null) {
            return v == FactoryMap.NULL ? null : (V)v;
        }
        V value = this.create(key);
        SoftReference<Object> valueRef = new SoftReference<Object>(value == null ? FactoryMap.NULL : value);
        SoftReference<Object> prevRef = this.myMap.putIfAbsent(key, valueRef);
        Object prev = prevRef == null ? null : prevRef.get();
        return (V)(prev == null || prev == FactoryMap.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

