/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceIterator<T>
implements Iterator<T> {
    private Iterator[] myIterators;
    private int myCurrentIndex;

    public SequenceIterator(Iterator[] iterators) {
        this.myIterators = new Iterator[iterators.length];
        for (int i = 0; i < iterators.length; ++i) {
            Iterator iterator;
            this.myIterators[i] = iterator = iterators[i];
        }
    }

    @Override
    public boolean hasNext() {
        if (this.myCurrentIndex >= this.myIterators.length) {
            return false;
        }
        if (this.myIterators[this.myCurrentIndex] == null) {
            ++this.myCurrentIndex;
            return this.hasNext();
        }
        if (this.myIterators[this.myCurrentIndex].hasNext()) {
            return true;
        }
        ++this.myCurrentIndex;
        return this.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return (T)this.myIterators[this.myCurrentIndex].next();
        }
        throw new NoSuchElementException("Iterator has no more elements");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public static <T> SequenceIterator<T> create(Iterator<T> first, Iterator<T> second) {
        return new SequenceIterator<T>(new Iterator[]{first, second});
    }

    public static <T> SequenceIterator<T> create(Iterator<T> first, Iterator<T> second, Iterator<T> third) {
        return new SequenceIterator<T>(new Iterator[]{first, second, third});
    }
}

