/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIntCache<K>
implements Iterable {
    public static final int defaultSize = 8192;
    public static final int minSize = 4;
    protected int myTop;
    protected int myBack;
    protected final CacheEntry[] myCache;
    protected final int[] myHashTable;
    protected int myHashTableSize;
    protected int myCount;
    protected int myFirstFree;
    protected final EventDispatcher<DeletedPairsListener> myEventDispatcher = EventDispatcher.create(DeletedPairsListener.class);
    private static final int[] tableSizes = new int[]{5, 11, 23, 47, 101, 199, 397, 797, 1597, 3191, 6397, 12799, 25589, 51199, 102397, 204793, 409579, 819157, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103};
    private long myAttempts;
    private long myHits;

    public ObjectIntCache() {
        this(8192);
    }

    public ObjectIntCache(int cacheSize) {
        int i;
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (i = 0; i < this.myCache.length; ++i) {
            this.myCache[i] = new CacheEntry();
        }
        this.myHashTableSize = cacheSize;
        i = 0;
        while (this.myHashTableSize > tableSizes[i]) {
            ++i;
        }
        this.myHashTableSize = tableSizes[i];
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0L;
        this.myHits = 0L;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(K key) {
        return this.isCached(key);
    }

    public int get(K key) {
        return this.tryKey(key);
    }

    public int put(K key, int value) {
        int oldValue = this.tryKey(key);
        if (oldValue != Integer.MIN_VALUE) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(K key) {
        int index = this.searchForCacheEntry(key);
        if (index != 0) {
            this.removeEntry(index);
            this.removeEntryFromHashTable(index);
            this.myCache[index].hash_next = this.myFirstFree;
            this.myFirstFree = index;
            this.fireListenersAboutDeletion(index);
            this.myCache[index].key = null;
        }
    }

    public void removeAll() {
        ArrayList<Object> keys = new ArrayList<Object>(this.count());
        int current = this.myTop;
        while (current > 0) {
            if (this.myCache[current].key != null) {
                keys.add(this.myCache[current].key);
            }
            current = this.myCache[current].next;
        }
        for (Object e : keys) {
            this.remove(e);
        }
    }

    public final void cacheObject(K key, int x) {
        int index = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index == 0) {
                index = this.myCount;
                ++index;
            } else {
                this.myFirstFree = this.myCache[index].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index;
            }
        } else {
            index = this.myBack;
            this.removeEntryFromHashTable(index);
            this.fireListenersAboutDeletion(index);
            this.myBack = this.myCache[index].prev;
            this.myCache[this.myCache[index].prev].next = 0;
        }
        this.myCache[index].key = key;
        this.myCache[index].value = x;
        this.addEntry2HashTable(index);
        this.add2Top(index);
    }

    public final int tryKey(K key) {
        ++this.myAttempts;
        int index = this.searchForCacheEntry(key);
        if (index == 0) {
            return Integer.MIN_VALUE;
        }
        ++this.myHits;
        if (index != this.myTop) {
            this.removeEntry(index);
            this.add2Top(index);
        }
        return this.myCache[index].value;
    }

    public final boolean isCached(K key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public double hitRate() {
        return this.myAttempts > 0L ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index) {
        this.myCache[index].next = this.myTop;
        this.myCache[index].prev = 0;
        this.myCache[this.myTop].prev = index;
        this.myTop = index;
    }

    private void removeEntry(int index) {
        if (index == this.myBack) {
            this.myBack = this.myCache[index].prev;
        } else {
            this.myCache[this.myCache[index].next].prev = this.myCache[index].prev;
        }
        if (index == this.myTop) {
            this.myTop = this.myCache[index].next;
        } else {
            this.myCache[this.myCache[index].prev].next = this.myCache[index].next;
        }
    }

    private void addEntry2HashTable(int index) {
        int hash_index = (this.myCache[index].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index) {
        int hash_index = (this.myCache[index].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[hash_index];
        int previous = 0;
        while (current != 0) {
            int next = this.myCache[current].hash_next;
            if (current == index) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next;
                } else {
                    this.myHashTable[hash_index] = next;
                }
                --this.myCount;
                break;
            }
            previous = current;
            current = next;
        }
    }

    private int searchForCacheEntry(K key) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[index];
        this.myCache[0].key = key;
        while (!key.equals(this.myCache[current].key)) {
            current = this.myCache[current].hash_next;
        }
        return current;
    }

    public Iterator iterator() {
        return new ObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener listener) {
        this.myEventDispatcher.addListener(listener);
    }

    public void removeDeletedPairsListener(DeletedPairsListener listener) {
        this.myEventDispatcher.addListener(listener);
    }

    private void fireListenersAboutDeletion(int index) {
        CacheEntry cacheEntry = this.myCache[index];
        this.myEventDispatcher.getMulticaster().objectRemoved(cacheEntry.key, cacheEntry.value);
    }

    public static interface DeletedPairsListener
    extends EventListener {
        public void objectRemoved(Object var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ObjectCacheIterator<K>
    implements Iterator {
        private ObjectIntCache<K> myCache;
        private int myCurrentEntry;

        public ObjectCacheIterator(ObjectIntCache<K> cache) {
            this.myCache = cache;
            this.myCurrentEntry = 0;
            cache.myCache[0].next = cache.myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = this.myCache.myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        public Object next() {
            return this.myCache.myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            this.myCache.remove(this.myCache.myCache[this.myCurrentEntry].key);
        }
    }

    protected static class CacheEntry {
        public Object key;
        public int value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }
}

