/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.IntObjectCache;
import com.intellij.util.containers.ObjectCache;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ObjectCacheTest
extends TestCase {
    private static final HashMap removedPairs = new HashMap();

    public void testCacheFiniteness() {
        ObjectCache<String, String> cache = new ObjectCache<String, String>(4);
        cache.put("Eclipse", "Sucking IDE");
        cache.put("IDEA", "good");
        cache.put("IDEA 4.5", "better");
        cache.put("IDEA 5.0", "perfect");
        cache.put("IDEA 6.0", "ideal");
        Assert.assertNull(cache.get("Eclipse"));
    }

    public void testCacheIterator() {
        ObjectCache<String, String> cache = new ObjectCache<String, String>(4);
        cache.put("Eclipse", "Sucking IDE");
        cache.put("IDEA", "good IDEA");
        cache.put("IDEA 4.5", "better IDEA");
        cache.put("IDEA 5.0", "perfect IDEA");
        cache.put("IDEA 6.0", "IDEAL");
        HashSet<String> values = new HashSet<String>();
        for (String obj : cache) {
            values.add(obj);
        }
        Assert.assertNull(cache.get("Eclipse"));
        Assert.assertFalse((boolean)values.contains("Sucking IDE"));
        Assert.assertTrue((boolean)values.contains("good IDEA"));
        Assert.assertTrue((boolean)values.contains("better IDEA"));
        Assert.assertTrue((boolean)values.contains("perfect IDEA"));
        Assert.assertTrue((boolean)values.contains("IDEAL"));
    }

    public void testCacheListeners() {
        ObjectCache<String, String> cache = new ObjectCache<String, String>(4);
        cache.addDeletedPairsListener(new CacheDeletedPairsListener());
        removedPairs.clear();
        cache.put("Eclipse", "Sucking IDE");
        cache.put("Eclipses", "Sucking IDEs");
        cache.put("IDEA", "good IDEA");
        cache.put("IDEA 4.5", "better IDEA");
        cache.put("IDEA 5.0", "perfect IDEA");
        cache.put("IDEA 6.0", "IDEAL");
        Assert.assertEquals((Object)"Sucking IDE", removedPairs.get("Eclipse"));
        Assert.assertEquals((Object)"Sucking IDEs", removedPairs.get("Eclipses"));
    }

    public void testIntCacheFiniteness() {
        IntObjectCache<Integer> cache = new IntObjectCache<Integer>(4);
        cache.put(0, 0);
        cache.put(1, 1);
        cache.put(2, 2);
        cache.put(3, 3);
        cache.put(4, 4);
        Assert.assertNull(cache.tryKey(0));
    }

    public void testIntCacheIterator() {
        IntObjectCache<Integer> cache = new IntObjectCache<Integer>(4);
        cache.put(0, 0);
        cache.put(1, 1);
        cache.put(2, 2);
        cache.put(3, 3);
        cache.put(4, 4);
        HashSet<Integer> values = new HashSet<Integer>();
        for (Integer obj : cache) {
            values.add(obj);
        }
        Assert.assertFalse((boolean)values.contains(0));
        Assert.assertTrue((boolean)values.contains(1));
        Assert.assertTrue((boolean)values.contains(2));
        Assert.assertTrue((boolean)values.contains(3));
        Assert.assertTrue((boolean)values.contains(4));
    }

    public void testIntCacheNegativeKeys() {
        IntObjectCache<Integer> cache = new IntObjectCache<Integer>(8);
        cache.put(-1, 1);
        cache.put(-2, 2);
        cache.put(-3, 3);
        cache.put(-4, 4);
        cache.put(1, 1);
        cache.put(2, 2);
        cache.put(3, 3);
        cache.put(4, 4);
        Assert.assertNull(cache.tryKey(0));
        Assert.assertNotNull(cache.tryKey(-1));
        Assert.assertNotNull(cache.tryKey(-2));
        Assert.assertNotNull(cache.tryKey(-3));
        Assert.assertNotNull(cache.tryKey(-4));
    }

    private class CacheDeletedPairsListener
    implements ObjectCache.DeletedPairsListener {
        private CacheDeletedPairsListener() {
        }

        public void objectRemoved(Object key, Object value) {
            removedPairs.put(key, value);
        }
    }
}

