/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockPoolSynchronizedMap<K, V>
extends THashMap<K, V> {
    private static final int NUM_LOCKS = 256;
    private static final Object[] ourLocks = new Object[256];
    private static int ourLockAllocationCounter = 0;
    private final Object mutex = LockPoolSynchronizedMap.allocateLock();

    public LockPoolSynchronizedMap() {
    }

    public LockPoolSynchronizedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public LockPoolSynchronizedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    private static Object allocateLock() {
        ourLockAllocationCounter = (ourLockAllocationCounter + 1) % 256;
        return ourLocks[ourLockAllocationCounter];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this.mutex;
        synchronized (object) {
            return super.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return (V)super.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        Object object = this.mutex;
        synchronized (object) {
            return (V)super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return (V)super.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        Object object = this.mutex;
        synchronized (object) {
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockPoolSynchronizedMap<K, V> clone() {
        Object object = this.mutex;
        synchronized (object) {
            return (LockPoolSynchronizedMap)super.clone();
        }
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    static {
        for (int i = 0; i < ourLocks.length; ++i) {
            LockPoolSynchronizedMap.ourLocks[i] = new Object();
        }
    }
}

